package com.biz.crm.sfa.activity;

import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.sfa.activity.req.SfaActivityExecutionReqVo;
import com.biz.crm.nebular.sfa.activity.resp.SfaActivityExecutionRespVo;
import com.biz.crm.sfa.activity.impl.SfaActivityExecutionFeignImpl;
import com.biz.crm.util.Result;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * 活动执行;feign接口
 *
 * @author lf
 * @date 2020-12-30 15:24:11
 */


@FeignClient(url ="${feign.urlip:}",qualifier = "SfaActivityExecutionFeign",name="crm-sfa",path = "tpm",fallbackFactory = SfaActivityExecutionFeignImpl.class)
public interface SfaActivityExecutionFeign {

    /**
     * 列表
     */
    @PostMapping("/sfaActivityExecutionController/list")
    Result<PageResult<SfaActivityExecutionRespVo>> list(@RequestBody SfaActivityExecutionReqVo sfaActivityExecutionReqVo);

    /**
     * 查询
     */
    @PostMapping("/sfaActivityExecutionController/query")
    Result<SfaActivityExecutionRespVo> query(@RequestBody SfaActivityExecutionReqVo sfaActivityExecutionReqVo);

    /**
     * 新增
     */
    @PostMapping("/sfaActivityExecutionController/save")
    Result save(@RequestBody SfaActivityExecutionReqVo sfaActivityExecutionReqVo);

    /**
     * 更新
     */
    @PostMapping("/sfaActivityExecutionController/update")
    Result update(@RequestBody SfaActivityExecutionReqVo sfaActivityExecutionReqVo);

    /**
     * 删除
     */
    @PostMapping("/sfaActivityExecutionController/delete")
    Result delete(@RequestBody SfaActivityExecutionReqVo sfaActivityExecutionReqVo);

    /**
     * 启用
     */
    @PostMapping("/sfaActivityExecutionController/enable")
    Result enable(@RequestBody SfaActivityExecutionReqVo sfaActivityExecutionReqVo);

    /**
     * 禁用
     */
    @PostMapping("/sfaActivityExecutionController/disable")
    Result disable(@RequestBody  SfaActivityExecutionReqVo sfaActivityExecutionReqVo);
}
