package com.biz.crm.sfa.activity.impl;

import com.biz.crm.base.BaseAbstract;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.sfa.activity.req.SfaActivityExecutionReqVo;
import com.biz.crm.nebular.sfa.activity.resp.SfaActivityExecutionRespVo;
import com.biz.crm.sfa.activity.SfaActivityExecutionFeign;
import com.biz.crm.util.Result;
import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.util.ArrayList;

/**
 * 活动执行;feign接口熔断类
 *
 * @author lf
 * @date 2020-12-30 15:24:11
 */
@Slf4j
@Component
public class SfaActivityExecutionFeignImpl extends BaseAbstract implements FallbackFactory<SfaActivityExecutionFeign> {

    @Override
    public SfaActivityExecutionFeign create(Throwable throwable) {
        log.error("进入熔断",throwable);
        return new SfaActivityExecutionFeign() {
             /**
              * 列表
              */
            @Override
            public Result<PageResult<SfaActivityExecutionRespVo>> list(SfaActivityExecutionReqVo sfaActivityExecutionReqVo) {
                doBack();
                PageResult<SfaActivityExecutionRespVo> build = PageResult.<SfaActivityExecutionRespVo>builder()
                        .data(new ArrayList<>())
                        .count(0L)
                        .build();
                return Result.ok(build);
            }

            /**
             * 查询
             */
            @Override
            public Result<SfaActivityExecutionRespVo> query(SfaActivityExecutionReqVo sfaActivityExecutionReqVo) {
                return doBack();
            }

            /**
             * 新增
             */
            @Override
            public Result save(SfaActivityExecutionReqVo sfaActivityExecutionReqVo) {
                return doBack();
            }

            /**
             * 更新
             */
            @Override
            public Result update(SfaActivityExecutionReqVo sfaActivityExecutionReqVo) {
                return doBack();
            }

            /**
             * 删除
             */
            @Override
            public Result delete(SfaActivityExecutionReqVo sfaActivityExecutionReqVo) {
                return doBack();
            }

            /**
             * 启用
             */
            @Override
            public Result enable(SfaActivityExecutionReqVo sfaActivityExecutionReqVo) {
                return doBack();
            }

            /**
             * 禁用
             */
            @Override
            public Result disable(SfaActivityExecutionReqVo sfaActivityExecutionReqVo) {
                return doBack();
            }
        };
    }
}
