package com.biz.crm.sfa.activity.impl;

import com.biz.crm.base.BaseAbstract;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.sfa.activity.req.SfaActivityProductReqVo;
import com.biz.crm.nebular.sfa.activity.resp.SfaActivityProductRespVo;
import com.biz.crm.sfa.activity.SfaActivityProductFeign;
import com.biz.crm.util.Result;
import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.util.ArrayList;

/**
 * 活动产品;feign接口熔断类
 *
 * @author lf
 * @date 2020-12-30 15:24:11
 */
@Slf4j
@Component
public class SfaActivityProductFeignImpl extends BaseAbstract implements FallbackFactory<SfaActivityProductFeign> {

    @Override
    public SfaActivityProductFeign create(Throwable throwable) {
        log.error("进入熔断",throwable);
        return new SfaActivityProductFeign() {
             /**
              * 列表
              */
            @Override
            public Result<PageResult<SfaActivityProductRespVo>> list(SfaActivityProductReqVo sfaActivityProductReqVo) {
                doBack();
                PageResult<SfaActivityProductRespVo> build = PageResult.<SfaActivityProductRespVo>builder()
                        .data(new ArrayList<>())
                        .count(0L)
                        .build();
                return Result.ok(build);
            }

            /**
             * 查询
             */
            @Override
            public Result<SfaActivityProductRespVo> query(SfaActivityProductReqVo sfaActivityProductReqVo) {
                return doBack();
            }

            /**
             * 新增
             */
            @Override
            public Result save(SfaActivityProductReqVo sfaActivityProductReqVo) {
                return doBack();
            }

            /**
             * 更新
             */
            @Override
            public Result update(SfaActivityProductReqVo sfaActivityProductReqVo) {
                return doBack();
            }

            /**
             * 删除
             */
            @Override
            public Result delete(SfaActivityProductReqVo sfaActivityProductReqVo) {
                return doBack();
            }

            /**
             * 启用
             */
            @Override
            public Result enable(SfaActivityProductReqVo sfaActivityProductReqVo) {
                return doBack();
            }

            /**
             * 禁用
             */
            @Override
            public Result disable(SfaActivityProductReqVo sfaActivityProductReqVo) {
                return doBack();
            }
        };
    }
}
