package com.biz.crm.sfa.acttask;

import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.sfa.acttask.req.SfaActProductReqVo;
import com.biz.crm.nebular.sfa.acttask.resp.SfaActProductRespVo;
import com.biz.crm.sfa.acttask.impl.SfaActProductFeignImpl;
import com.biz.crm.util.Result;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * 活动任务管理-陈列要求 feign接口
 *
 * @author liuhongming
 * @date 2020-09-23 11:24:25
 */


@FeignClient(url ="${feign.urlip:}",qualifier = "SfaActProductFeign",name="crm-sfa",path = "sfa",fallbackFactory = SfaActProductFeignImpl.class)
public interface SfaActProductFeign {

    /**
     * 列表
     */
    @PostMapping("/sfaactproduct/list")
    Result<PageResult<SfaActProductRespVo>> list(@RequestBody SfaActProductReqVo sfaActProductReqVo);

    /**
     * 查询
     */
    @PostMapping("/sfaactproduct/query")
    Result<SfaActProductRespVo> query(@RequestBody SfaActProductReqVo sfaActProductReqVo);

    /**
     * 新增
     */
    @PostMapping("/sfaactproduct/save")
    Result save(@RequestBody SfaActProductReqVo sfaActProductReqVo);

    /**
     * 更新
     */
    @PostMapping("/sfaactproduct/update")
    Result update(@RequestBody SfaActProductReqVo sfaActProductReqVo);

    /**
     * 删除
     */
    @PostMapping("/sfaactproduct/delete")
    Result delete(@RequestBody SfaActProductReqVo sfaActProductReqVo);

    /**
     * 启用
     */
    @PostMapping("/sfaactproduct/enable")
    Result enable(@RequestBody SfaActProductReqVo sfaActProductReqVo);

    /**
     * 禁用
     */
    @PostMapping("/sfaactproduct/disable")
    Result disable(@RequestBody SfaActProductReqVo sfaActProductReqVo);
}
