package com.biz.crm.sfa.acttask;

import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.sfa.acttask.req.SfaActTaskReqVo;
import com.biz.crm.nebular.sfa.acttask.resp.SfaActTaskRespVo;
import com.biz.crm.sfa.acttask.impl.SfaActTaskFeignImpl;
import com.biz.crm.util.Result;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * 活动任务管理 feign接口
 *
 * @author liuhongming
 * @date 2020-09-23 11:24:25
 */


@FeignClient(url ="${feign.urlip:}",qualifier = "SfaActTaskFeign",name="crm-sfa",path = "sfa",fallbackFactory = SfaActTaskFeignImpl.class)
public interface SfaActTaskFeign {

    /**
     * 列表
     */
    @PostMapping("/sfaacttask/list")
    Result<PageResult<SfaActTaskRespVo>> list(@RequestBody SfaActTaskReqVo sfaActTaskReqVo);

    /**
     * 查询
     */
    @PostMapping("/sfaacttask/query")
    Result<SfaActTaskRespVo> query(@RequestBody SfaActTaskReqVo sfaActTaskReqVo);

    /**
     * 新增
     */
    @PostMapping("/sfaacttask/save")
    Result save(@RequestBody SfaActTaskReqVo sfaActTaskReqVo);

    /**
     * 更新
     */
    @PostMapping("/sfaacttask/update")
    Result update(@RequestBody SfaActTaskReqVo sfaActTaskReqVo);

    /**
     * 删除
     */
    @PostMapping("/sfaacttask/delete")
    Result delete(@RequestBody SfaActTaskReqVo sfaActTaskReqVo);

    /**
     * 启用
     */
    @PostMapping("/sfaacttask/enable")
    Result enable(@RequestBody SfaActTaskReqVo sfaActTaskReqVo);

    /**
     * 禁用
     */
    @PostMapping("/sfaacttask/disable")
    Result disable(@RequestBody SfaActTaskReqVo sfaActTaskReqVo);
}
