package com.biz.crm.sfa.acttask.impl;

import com.biz.crm.base.BaseAbstract;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.sfa.acttask.req.SfaActFileReqVo;
import com.biz.crm.nebular.sfa.acttask.resp.SfaActFileRespVo;
import com.biz.crm.sfa.acttask.SfaActFileFeign;
import com.biz.crm.util.Result;
import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.util.ArrayList;

/**
 * 活动附件（示例图片） feign接口熔断类
 *
 * @author liuhongming
 * @date 2020-09-23 11:24:25
 */
@Slf4j
@Component
public class SfaActFileFeignImpl extends BaseAbstract implements FallbackFactory<SfaActFileFeign> {

    @Override
    public SfaActFileFeign create(Throwable throwable) {
        log.error("进入熔断",throwable);
        return new SfaActFileFeign() {
             /**
              * 列表
              */
            @Override
            public Result<PageResult<SfaActFileRespVo>> list(SfaActFileReqVo sfaActFileReqVo) {
                doBack();
                PageResult<SfaActFileRespVo> build = PageResult.<SfaActFileRespVo>builder()
                        .data(new ArrayList<>())
                        .count(0L)
                        .build();
                return Result.ok(build);
            }

            /**
             * 查询
             */
            @Override
            public Result<SfaActFileRespVo> query(SfaActFileReqVo sfaActFileReqVo) {
                return doBack();
            }

            /**
             * 新增
             */
            @Override
            public Result save(SfaActFileReqVo sfaActFileReqVo) {
                return doBack();
            }

            /**
             * 更新
             */
            @Override
            public Result update(SfaActFileReqVo sfaActFileReqVo) {
                return doBack();
            }

            /**
             * 删除
             */
            @Override
            public Result delete(SfaActFileReqVo sfaActFileReqVo) {
                return doBack();
            }

            /**
             * 启用
             */
            @Override
            public Result enable(SfaActFileReqVo sfaActFileReqVo) {
                return doBack();
            }

            /**
             * 禁用
             */
            @Override
            public Result disable(SfaActFileReqVo sfaActFileReqVo) {
                return doBack();
            }
        };
    }
}
