package com.biz.crm.sfa.acttask.impl;

import com.biz.crm.base.BaseAbstract;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.sfa.acttask.req.SfaActTaskReqVo;
import com.biz.crm.nebular.sfa.acttask.resp.SfaActTaskRespVo;
import com.biz.crm.sfa.acttask.SfaActTaskFeign;
import com.biz.crm.util.Result;
import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.util.ArrayList;

/**
 * 活动任务管理 feign接口熔断类
 *
 * @author liuhongming
 * @date 2020-09-23 11:24:25
 */
@Slf4j
@Component
public class SfaActTaskFeignImpl extends BaseAbstract implements FallbackFactory<SfaActTaskFeign> {

    @Override
    public SfaActTaskFeign create(Throwable throwable) {
        log.error("进入熔断",throwable);
        return new SfaActTaskFeign() {
             /**
              * 列表
              */
            @Override
            public Result<PageResult<SfaActTaskRespVo>> list(SfaActTaskReqVo sfaActTaskReqVo) {
                doBack();
                PageResult<SfaActTaskRespVo> build = PageResult.<SfaActTaskRespVo>builder()
                        .data(new ArrayList<>())
                        .count(0L)
                        .build();
                return Result.ok(build);
            }

            /**
             * 查询
             */
            @Override
            public Result<SfaActTaskRespVo> query(SfaActTaskReqVo sfaActTaskReqVo) {
                return doBack();
            }

            /**
             * 新增
             */
            @Override
            public Result save(SfaActTaskReqVo sfaActTaskReqVo) {
                return doBack();
            }

            /**
             * 更新
             */
            @Override
            public Result update(SfaActTaskReqVo sfaActTaskReqVo) {
                return doBack();
            }

            /**
             * 删除
             */
            @Override
            public Result delete(SfaActTaskReqVo sfaActTaskReqVo) {
                return doBack();
            }

            /**
             * 启用
             */
            @Override
            public Result enable(SfaActTaskReqVo sfaActTaskReqVo) {
                return doBack();
            }

            /**
             * 禁用
             */
            @Override
            public Result disable(SfaActTaskReqVo sfaActTaskReqVo) {
                return doBack();
            }
        };
    }
}
