package com.biz.crm.sfa.assistant;

import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.sfa.assistant.req.SfaWorkSummaryReqVo;
import com.biz.crm.nebular.sfa.assistant.resp.SfaWorkSummaryRespVo;
import com.biz.crm.sfa.assistant.impl.SfaWorkSummaryFeignImpl;
import com.biz.crm.util.Result;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * 工作总结 feign接口
 *
 * @author liuhongming
 * @date 2020-10-14 19:54:03
 */


@FeignClient(url ="${feign.urlip:}",qualifier = "SfaWorkSummaryFeign",name="crm-sfa",path = "sfa",fallbackFactory = SfaWorkSummaryFeignImpl.class)
public interface SfaWorkSummaryFeign {

    /**
     * 列表
     */
    @PostMapping("/sfaworksummary/list")
    Result<PageResult<SfaWorkSummaryRespVo>> list(@RequestBody SfaWorkSummaryReqVo sfaWorkSummaryReqVo);

    /**
     * 查询
     */
    @PostMapping("/sfaworksummary/query")
    Result<SfaWorkSummaryRespVo> query(@RequestBody SfaWorkSummaryReqVo sfaWorkSummaryReqVo);

    /**
     * 新增
     */
    @PostMapping("/sfaworksummary/save")
    Result save(@RequestBody SfaWorkSummaryReqVo sfaWorkSummaryReqVo);

    /**
     * 更新
     */
    @PostMapping("/sfaworksummary/update")
    Result update(@RequestBody SfaWorkSummaryReqVo sfaWorkSummaryReqVo);

    /**
     * 删除
     */
    @PostMapping("/sfaworksummary/delete")
    Result delete(@RequestBody SfaWorkSummaryReqVo sfaWorkSummaryReqVo);

    /**
     * 启用
     */
    @PostMapping("/sfaworksummary/enable")
    Result enable(@RequestBody SfaWorkSummaryReqVo sfaWorkSummaryReqVo);

    /**
     * 禁用
     */
    @PostMapping("/sfaworksummary/disable")
    Result disable(@RequestBody SfaWorkSummaryReqVo sfaWorkSummaryReqVo);
}
