package com.biz.crm.sfa.assistant;

import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.sfa.assistant.req.SfaWorkTaskNoticeReqVo;
import com.biz.crm.nebular.sfa.assistant.resp.SfaWorkTaskNoticeRespVo;
import com.biz.crm.sfa.assistant.impl.SfaWorkTaskNoticeFeignImpl;
import com.biz.crm.util.Result;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * 工作任务(抄送) feign接口
 *
 * @author liuhongming
 * @date 2020-10-14 19:54:03
 */


@FeignClient(url ="${feign.urlip:}",qualifier = "SfaWorkTaskNoticeFeign",name="crm-sfa",path = "sfa",fallbackFactory = SfaWorkTaskNoticeFeignImpl.class)
public interface SfaWorkTaskNoticeFeign {

    /**
     * 列表
     */
    @PostMapping("/sfaworktasknotice/list")
    Result<PageResult<SfaWorkTaskNoticeRespVo>> list(@RequestBody SfaWorkTaskNoticeReqVo sfaWorkTaskNoticeReqVo);

    /**
     * 查询
     */
    @PostMapping("/sfaworktasknotice/query")
    Result<SfaWorkTaskNoticeRespVo> query(@RequestBody SfaWorkTaskNoticeReqVo sfaWorkTaskNoticeReqVo);

    /**
     * 新增
     */
    @PostMapping("/sfaworktasknotice/save")
    Result save(@RequestBody SfaWorkTaskNoticeReqVo sfaWorkTaskNoticeReqVo);

    /**
     * 更新
     */
    @PostMapping("/sfaworktasknotice/update")
    Result update(@RequestBody SfaWorkTaskNoticeReqVo sfaWorkTaskNoticeReqVo);

    /**
     * 删除
     */
    @PostMapping("/sfaworktasknotice/delete")
    Result delete(@RequestBody SfaWorkTaskNoticeReqVo sfaWorkTaskNoticeReqVo);

    /**
     * 启用
     */
    @PostMapping("/sfaworktasknotice/enable")
    Result enable(@RequestBody SfaWorkTaskNoticeReqVo sfaWorkTaskNoticeReqVo);

    /**
     * 禁用
     */
    @PostMapping("/sfaworktasknotice/disable")
    Result disable(@RequestBody SfaWorkTaskNoticeReqVo sfaWorkTaskNoticeReqVo);
}
