package com.biz.crm.sfa.assistant.impl;

import com.biz.crm.base.BaseAbstract;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.sfa.assistant.req.SfaWorkTaskNoticeReqVo;
import com.biz.crm.nebular.sfa.assistant.resp.SfaWorkTaskNoticeRespVo;
import com.biz.crm.sfa.assistant.SfaWorkTaskNoticeFeign;
import com.biz.crm.util.Result;
import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.util.ArrayList;

/**
 * 工作任务(抄送) feign接口熔断类
 *
 * @author liuhongming
 * @date 2020-10-14 19:54:03
 */
@Slf4j
@Component
public class SfaWorkTaskNoticeFeignImpl extends BaseAbstract implements FallbackFactory<SfaWorkTaskNoticeFeign> {

    @Override
    public SfaWorkTaskNoticeFeign create(Throwable throwable) {
        log.error("进入熔断",throwable);
        return new SfaWorkTaskNoticeFeign() {
             /**
              * 列表
              */
            @Override
            public Result<PageResult<SfaWorkTaskNoticeRespVo>> list(SfaWorkTaskNoticeReqVo sfaWorkTaskNoticeReqVo) {
                doBack();
                PageResult<SfaWorkTaskNoticeRespVo> build = PageResult.<SfaWorkTaskNoticeRespVo>builder()
                        .data(new ArrayList<>())
                        .count(0L)
                        .build();
                return Result.ok(build);
            }

            /**
             * 查询
             */
            @Override
            public Result<SfaWorkTaskNoticeRespVo> query(SfaWorkTaskNoticeReqVo sfaWorkTaskNoticeReqVo) {
                return doBack();
            }

            /**
             * 新增
             */
            @Override
            public Result save(SfaWorkTaskNoticeReqVo sfaWorkTaskNoticeReqVo) {
                return doBack();
            }

            /**
             * 更新
             */
            @Override
            public Result update(SfaWorkTaskNoticeReqVo sfaWorkTaskNoticeReqVo) {
                return doBack();
            }

            /**
             * 删除
             */
            @Override
            public Result delete(SfaWorkTaskNoticeReqVo sfaWorkTaskNoticeReqVo) {
                return doBack();
            }

            /**
             * 启用
             */
            @Override
            public Result enable(SfaWorkTaskNoticeReqVo sfaWorkTaskNoticeReqVo) {
                return doBack();
            }

            /**
             * 禁用
             */
            @Override
            public Result disable(SfaWorkTaskNoticeReqVo sfaWorkTaskNoticeReqVo) {
                return doBack();
            }
        };
    }
}
