package com.biz.crm.sfa.audit;

import com.biz.crm.sfa.audit.impl.SfaAuditAttendanceFeignImpl;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;
import com.biz.crm.nebular.sfa.audit.resp.SfaAuditAttendanceRespVo;
import com.biz.crm.nebular.sfa.audit.req.SfaAuditAttendanceReqVo;
import com.biz.crm.common.PageResult;
import com.biz.crm.util.Result;
import javax.validation.Valid;


/**
 * 考勤稽查表feign接口
 *
 * @author rwm
 * @date 2022-04-13 17:58:57
 */


@FeignClient(url ="${feign.urlip:}",qualifier = "SfaAuditAttendanceFeign",name="crm-sfa",path = "tpm",fallbackFactory = SfaAuditAttendanceFeignImpl.class)
public interface SfaAuditAttendanceFeign {

    /**
     * 列表
     */
    @PostMapping("/sfaauditattendance/list")
    Result<PageResult<SfaAuditAttendanceRespVo>> list(@RequestBody SfaAuditAttendanceReqVo sfaAuditAttendanceReqVo);

    /**
     * 查询
     */
    @PostMapping("/sfaauditattendance/query")
    Result<SfaAuditAttendanceRespVo> query(@RequestBody SfaAuditAttendanceReqVo sfaAuditAttendanceReqVo);

    /**
     * 新增
     */
    @PostMapping("/sfaauditattendance/save")
    Result save(@RequestBody SfaAuditAttendanceReqVo sfaAuditAttendanceReqVo);

    /**
     * 更新
     */
    @PostMapping("/sfaauditattendance/update")
    Result update(@RequestBody SfaAuditAttendanceReqVo sfaAuditAttendanceReqVo);

    /**
     * 删除
     */
    @PostMapping("/sfaauditattendance/delete")
    Result delete(@RequestBody SfaAuditAttendanceReqVo sfaAuditAttendanceReqVo);

    /**
     * 启用
     */
    @PostMapping("/sfaauditattendance/enable")
    Result enable(@RequestBody SfaAuditAttendanceReqVo sfaAuditAttendanceReqVo);

    /**
     * 禁用
     */
    @PostMapping("/sfaauditattendance/disable")
    Result disable(@RequestBody  SfaAuditAttendanceReqVo sfaAuditAttendanceReqVo);
}
