package com.biz.crm.sfa.audit;

import com.biz.crm.sfa.audit.impl.SfaAuditInspectorsFeignImpl;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;
import com.biz.crm.nebular.sfa.audit.resp.SfaAuditInspectorsRespVo;
import com.biz.crm.nebular.sfa.audit.req.SfaAuditInspectorsReqVo;
import com.biz.crm.common.PageResult;
import com.biz.crm.util.Result;
import javax.validation.Valid;


/**
 * 稽查人员区域配置表feign接口
 *
 * @author rwm
 * @date 2022-04-13 17:58:57
 */


@FeignClient(url ="${feign.urlip:}",qualifier = "SfaAuditInspectorsFeign",name="crm-sfa",path = "tpm",fallbackFactory = SfaAuditInspectorsFeignImpl.class)
public interface SfaAuditInspectorsFeign {

    /**
     * 列表
     */
    @PostMapping("/sfaauditinspectors/list")
    Result<PageResult<SfaAuditInspectorsRespVo>> list(@RequestBody SfaAuditInspectorsReqVo sfaAuditInspectorsReqVo);

    /**
     * 查询
     */
    @PostMapping("/sfaauditinspectors/query")
    Result<SfaAuditInspectorsRespVo> query(@RequestBody SfaAuditInspectorsReqVo sfaAuditInspectorsReqVo);

    /**
     * 新增
     */
    @PostMapping("/sfaauditinspectors/save")
    Result save(@RequestBody SfaAuditInspectorsReqVo sfaAuditInspectorsReqVo);

    /**
     * 更新
     */
    @PostMapping("/sfaauditinspectors/update")
    Result update(@RequestBody SfaAuditInspectorsReqVo sfaAuditInspectorsReqVo);

    /**
     * 删除
     */
    @PostMapping("/sfaauditinspectors/delete")
    Result delete(@RequestBody SfaAuditInspectorsReqVo sfaAuditInspectorsReqVo);

    /**
     * 启用
     */
    @PostMapping("/sfaauditinspectors/enable")
    Result enable(@RequestBody SfaAuditInspectorsReqVo sfaAuditInspectorsReqVo);

    /**
     * 禁用
     */
    @PostMapping("/sfaauditinspectors/disable")
    Result disable(@RequestBody  SfaAuditInspectorsReqVo sfaAuditInspectorsReqVo);
}
