package com.biz.crm.sfa.audit;

import com.biz.crm.sfa.audit.impl.SfaAuditTransregionalFeignImpl;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;
import com.biz.crm.nebular.sfa.audit.resp.SfaAuditTransregionalRespVo;
import com.biz.crm.nebular.sfa.audit.req.SfaAuditTransregionalReqVo;
import com.biz.crm.common.PageResult;
import com.biz.crm.util.Result;
import javax.validation.Valid;


/**
 * 窜货稽查表feign接口
 *
 * @author rwm
 * @date 2022-04-13 17:58:57
 */


@FeignClient(url ="${feign.urlip:}",qualifier = "SfaAuditTransregionalFeign",name="crm-sfa",path = "tpm",fallbackFactory = SfaAuditTransregionalFeignImpl.class)
public interface SfaAuditTransregionalFeign {

    /**
     * 列表
     */
    @PostMapping("/sfaaudittransregional/list")
    Result<PageResult<SfaAuditTransregionalRespVo>> list(@RequestBody SfaAuditTransregionalReqVo sfaAuditTransregionalReqVo);

    /**
     * 查询
     */
    @PostMapping("/sfaaudittransregional/query")
    Result<SfaAuditTransregionalRespVo> query(@RequestBody SfaAuditTransregionalReqVo sfaAuditTransregionalReqVo);

    /**
     * 新增
     */
    @PostMapping("/sfaaudittransregional/save")
    Result save(@RequestBody SfaAuditTransregionalReqVo sfaAuditTransregionalReqVo);

    /**
     * 更新
     */
    @PostMapping("/sfaaudittransregional/update")
    Result update(@RequestBody SfaAuditTransregionalReqVo sfaAuditTransregionalReqVo);

    /**
     * 删除
     */
    @PostMapping("/sfaaudittransregional/delete")
    Result delete(@RequestBody SfaAuditTransregionalReqVo sfaAuditTransregionalReqVo);

    /**
     * 启用
     */
    @PostMapping("/sfaaudittransregional/enable")
    Result enable(@RequestBody SfaAuditTransregionalReqVo sfaAuditTransregionalReqVo);

    /**
     * 禁用
     */
    @PostMapping("/sfaaudittransregional/disable")
    Result disable(@RequestBody  SfaAuditTransregionalReqVo sfaAuditTransregionalReqVo);
}
