package com.biz.crm.sfa.audit.impl;

import com.biz.crm.sfa.audit.SfaAuditProductPriceFeign;
import lombok.extern.slf4j.Slf4j;
import com.biz.crm.nebular.sfa.audit.resp.SfaAuditProductPriceRespVo;
import com.biz.crm.nebular.sfa.audit.req.SfaAuditProductPriceReqVo;
import com.biz.crm.common.PageResult;
import com.biz.crm.util.Result;
import com.biz.crm.base.BaseAbstract;
import org.springframework.stereotype.Component;

import feign.hystrix.FallbackFactory;
import java.util.ArrayList;

/**
 * 产品价格稽查主表feign接口熔断类
 *
 * @author rwm
 * @date 2022-04-13 17:58:57
 */
@Slf4j
@Component
public class SfaAuditProductPriceFeignImpl extends BaseAbstract implements FallbackFactory<SfaAuditProductPriceFeign> {

    @Override
    public SfaAuditProductPriceFeign create(Throwable throwable) {
        log.error("进入熔断",throwable);
        return new SfaAuditProductPriceFeign() {
             /**
              * 列表
              */
            @Override
            public Result<PageResult<SfaAuditProductPriceRespVo>> list(SfaAuditProductPriceReqVo sfaAuditProductPriceReqVo) {
                doBack();
                PageResult<SfaAuditProductPriceRespVo> build = PageResult.<SfaAuditProductPriceRespVo>builder()
                        .data(new ArrayList<>())
                        .count(0L)
                        .build();
                return Result.ok(build);
            }

            /**
             * 查询
             */
            @Override
            public Result<SfaAuditProductPriceRespVo> query(SfaAuditProductPriceReqVo sfaAuditProductPriceReqVo) {
                return doBack();
            }

            /**
             * 新增
             */
            @Override
            public Result save(SfaAuditProductPriceReqVo sfaAuditProductPriceReqVo) {
                return doBack();
            }

            /**
             * 更新
             */
            @Override
            public Result update(SfaAuditProductPriceReqVo sfaAuditProductPriceReqVo) {
                return doBack();
            }

            /**
             * 删除
             */
            @Override
            public Result delete(SfaAuditProductPriceReqVo sfaAuditProductPriceReqVo) {
                return doBack();
            }

            /**
             * 启用
             */
            @Override
            public Result enable(SfaAuditProductPriceReqVo sfaAuditProductPriceReqVo) {
                return doBack();
            }

            /**
             * 禁用
             */
            @Override
            public Result disable(SfaAuditProductPriceReqVo sfaAuditProductPriceReqVo) {
                return doBack();
            }
        };
    }
}
