package com.biz.crm.sfa.audit.impl;

import com.biz.crm.sfa.audit.SfaAuditTerminalRealFeign;
import lombok.extern.slf4j.Slf4j;
import com.biz.crm.nebular.sfa.audit.resp.SfaAuditTerminalRealRespVo;
import com.biz.crm.nebular.sfa.audit.req.SfaAuditTerminalRealReqVo;
import com.biz.crm.common.PageResult;
import com.biz.crm.util.Result;
import com.biz.crm.base.BaseAbstract;
import org.springframework.stereotype.Component;

import feign.hystrix.FallbackFactory;
import java.util.ArrayList;

/**
 * 终端真实性稽查表feign接口熔断类
 *
 * @author rwm
 * @date 2022-04-13 17:58:57
 */
@Slf4j
@Component
public class SfaAuditTerminalRealFeignImpl extends BaseAbstract implements FallbackFactory<SfaAuditTerminalRealFeign> {

    @Override
    public SfaAuditTerminalRealFeign create(Throwable throwable) {
        log.error("进入熔断",throwable);
        return new SfaAuditTerminalRealFeign() {
             /**
              * 列表
              */
            @Override
            public Result<PageResult<SfaAuditTerminalRealRespVo>> list(SfaAuditTerminalRealReqVo sfaAuditTerminalRealReqVo) {
                doBack();
                PageResult<SfaAuditTerminalRealRespVo> build = PageResult.<SfaAuditTerminalRealRespVo>builder()
                        .data(new ArrayList<>())
                        .count(0L)
                        .build();
                return Result.ok(build);
            }

            /**
             * 查询
             */
            @Override
            public Result<SfaAuditTerminalRealRespVo> query(SfaAuditTerminalRealReqVo sfaAuditTerminalRealReqVo) {
                return doBack();
            }

            /**
             * 新增
             */
            @Override
            public Result save(SfaAuditTerminalRealReqVo sfaAuditTerminalRealReqVo) {
                return doBack();
            }

            /**
             * 更新
             */
            @Override
            public Result update(SfaAuditTerminalRealReqVo sfaAuditTerminalRealReqVo) {
                return doBack();
            }

            /**
             * 删除
             */
            @Override
            public Result delete(SfaAuditTerminalRealReqVo sfaAuditTerminalRealReqVo) {
                return doBack();
            }

            /**
             * 启用
             */
            @Override
            public Result enable(SfaAuditTerminalRealReqVo sfaAuditTerminalRealReqVo) {
                return doBack();
            }

            /**
             * 禁用
             */
            @Override
            public Result disable(SfaAuditTerminalRealReqVo sfaAuditTerminalRealReqVo) {
                return doBack();
            }
        };
    }
}
