package com.biz.crm.sfa.calculateSalary;

import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.sfa.calculateSalary.req.SfaCalculateSalaryDateReqVo;
import com.biz.crm.nebular.sfa.calculateSalary.resp.SfaCalculateSalaryDateRespVo;
import com.biz.crm.sfa.calculateSalary.impl.SfaCalculateSalaryDateFeignImpl;
import com.biz.crm.util.Result;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * 计算薪资日期feign接口
 *
 * @author lf
 * @date 2020-12-28 15:00:09
 */


@FeignClient(url ="${feign.urlip:}",qualifier = "SfaCalculateSalaryDateFeign",name="crm-sfa",path = "tpm",fallbackFactory = SfaCalculateSalaryDateFeignImpl.class)
public interface SfaCalculateSalaryDateFeign {

    /**
     * 列表
     */
    @PostMapping("/sfaCalculateSalaryDateController/list")
    Result<PageResult<SfaCalculateSalaryDateRespVo>> list(@RequestBody SfaCalculateSalaryDateReqVo sfaCalculateSalaryDateReqVo);

    /**
     * 查询
     */
    @PostMapping("/sfaCalculateSalaryDateController/query")
    Result<SfaCalculateSalaryDateRespVo> query(@RequestBody SfaCalculateSalaryDateReqVo sfaCalculateSalaryDateReqVo);

    /**
     * 新增
     */
    @PostMapping("/sfaCalculateSalaryDateController/save")
    Result save(@RequestBody SfaCalculateSalaryDateReqVo sfaCalculateSalaryDateReqVo);

    /**
     * 更新
     */
    @PostMapping("/sfaCalculateSalaryDateController/update")
    Result update(@RequestBody SfaCalculateSalaryDateReqVo sfaCalculateSalaryDateReqVo);

    /**
     * 删除
     */
    @PostMapping("/sfaCalculateSalaryDateController/delete")
    Result delete(@RequestBody SfaCalculateSalaryDateReqVo sfaCalculateSalaryDateReqVo);

    /**
     * 启用
     */
    @PostMapping("/sfaCalculateSalaryDateController/enable")
    Result enable(@RequestBody SfaCalculateSalaryDateReqVo sfaCalculateSalaryDateReqVo);

    /**
     * 禁用
     */
    @PostMapping("/sfaCalculateSalaryDateController/disable")
    Result disable(@RequestBody  SfaCalculateSalaryDateReqVo sfaCalculateSalaryDateReqVo);
}
