package com.biz.crm.sfa.calculateSalary;

import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.sfa.calculateSalary.req.SfaCalculateSalaryYearReqVo;
import com.biz.crm.nebular.sfa.calculateSalary.resp.SfaCalculateSalaryYearRespVo;
import com.biz.crm.sfa.calculateSalary.impl.SfaCalculateSalaryYearFeignImpl;
import com.biz.crm.util.Result;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * 计算薪资年 feign接口
 *
 * @author lf
 * @date 2020-12-28 15:00:09
 */


@FeignClient(url ="${feign.urlip:}",qualifier = "SfaCalculateSalaryYearFeign",name="crm-sfa",path = "tpm",fallbackFactory = SfaCalculateSalaryYearFeignImpl.class)
public interface SfaCalculateSalaryYearFeign {

    /**
     * 列表
     */
    @PostMapping("/sfaCalculateSalaryYearController/list")
    Result<PageResult<SfaCalculateSalaryYearRespVo>> list(@RequestBody SfaCalculateSalaryYearReqVo sfaCalculateSalaryYearReqVo);

    /**
     * 查询
     */
    @PostMapping("/sfaCalculateSalaryYearController/query")
    Result<SfaCalculateSalaryYearRespVo> query(@RequestBody SfaCalculateSalaryYearReqVo sfaCalculateSalaryYearReqVo);

    /**
     * 新增
     */
    @PostMapping("/sfaCalculateSalaryYearController/save")
    Result save(@RequestBody SfaCalculateSalaryYearReqVo sfaCalculateSalaryYearReqVo);

    /**
     * 更新
     */
    @PostMapping("/sfaCalculateSalaryYearController/update")
    Result update(@RequestBody SfaCalculateSalaryYearReqVo sfaCalculateSalaryYearReqVo);

    /**
     * 删除
     */
    @PostMapping("/sfaCalculateSalaryYearController/delete")
    Result delete(@RequestBody SfaCalculateSalaryYearReqVo sfaCalculateSalaryYearReqVo);

    /**
     * 启用
     */
    @PostMapping("/sfaCalculateSalaryYearController/enable")
    Result enable(@RequestBody SfaCalculateSalaryYearReqVo sfaCalculateSalaryYearReqVo);

    /**
     * 禁用
     */
    @PostMapping("/sfaCalculateSalaryYearController/disable")
    Result disable(@RequestBody  SfaCalculateSalaryYearReqVo sfaCalculateSalaryYearReqVo);
}
