package com.biz.crm.sfa.collection;

import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.sfa.collection.req.SfaVisitRoleConfigReqVo;
import com.biz.crm.nebular.sfa.collection.resp.SfaVisitRoleConfigRespVo;
import com.biz.crm.sfa.collection.impl.SfaVisitRoleConfigFeignImpl;
import com.biz.crm.util.Result;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * 拜访步骤配置(角色) feign接口
 *
 * @author liuhongming
 * @date 2020-09-18 14:49:32
 */


@FeignClient(url ="${feign.urlip:}",qualifier = "SfaVisitRoleConfigFeign",name="crm-sfa",path = "sfa",fallbackFactory = SfaVisitRoleConfigFeignImpl.class)
public interface SfaVisitRoleConfigFeign {

    /**
     * 列表
     */
    @PostMapping("/sfavisitroleconfig/list")
    Result<PageResult<SfaVisitRoleConfigRespVo>> list(@RequestBody SfaVisitRoleConfigReqVo sfaVisitRoleConfigReqVo);

    /**
     * 查询
     */
    @PostMapping("/sfavisitroleconfig/query")
    Result<SfaVisitRoleConfigRespVo> query(@RequestBody SfaVisitRoleConfigReqVo sfaVisitRoleConfigReqVo);

    /**
     * 新增
     */
    @PostMapping("/sfavisitroleconfig/save")
    Result save(@RequestBody SfaVisitRoleConfigReqVo sfaVisitRoleConfigReqVo);

    /**
     * 更新
     */
    @PostMapping("/sfavisitroleconfig/update")
    Result update(@RequestBody SfaVisitRoleConfigReqVo sfaVisitRoleConfigReqVo);

    /**
     * 删除
     */
    @PostMapping("/sfavisitroleconfig/delete")
    Result delete(@RequestBody SfaVisitRoleConfigReqVo sfaVisitRoleConfigReqVo);

    /**
     * 启用
     */
    @PostMapping("/sfavisitroleconfig/enable")
    Result enable(@RequestBody SfaVisitRoleConfigReqVo sfaVisitRoleConfigReqVo);

    /**
     * 禁用
     */
    @PostMapping("/sfavisitroleconfig/disable")
    Result disable(@RequestBody SfaVisitRoleConfigReqVo sfaVisitRoleConfigReqVo);
}
