package com.biz.crm.sfa.collection;

import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.sfa.collection.req.SfaVisitRoleDirectoryReqVo;
import com.biz.crm.nebular.sfa.collection.resp.SfaVisitRoleDirectoryRespVo;
import com.biz.crm.sfa.collection.impl.SfaVisitRoleDirectoryFeignImpl;
import com.biz.crm.util.Result;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * 拜访步骤配置(角色)--拜访步骤表单配置 feign接口
 *
 * @author liuhongming
 * @date 2020-09-18 14:49:32
 */


@FeignClient(url ="${feign.urlip:}",qualifier = "SfaVisitRoleDirectoryFeign",name="crm-sfa",path = "sfa",fallbackFactory = SfaVisitRoleDirectoryFeignImpl.class)
public interface SfaVisitRoleDirectoryFeign {

    /**
     * 列表
     */
    @PostMapping("/sfavisitroledirectory/list")
    Result<PageResult<SfaVisitRoleDirectoryRespVo>> list(@RequestBody SfaVisitRoleDirectoryReqVo sfaVisitRoleDirectoryReqVo);

    /**
     * 查询
     */
    @PostMapping("/sfavisitroledirectory/query")
    Result<SfaVisitRoleDirectoryRespVo> query(@RequestBody SfaVisitRoleDirectoryReqVo sfaVisitRoleDirectoryReqVo);

    /**
     * 新增
     */
    @PostMapping("/sfavisitroledirectory/save")
    Result save(@RequestBody SfaVisitRoleDirectoryReqVo sfaVisitRoleDirectoryReqVo);

    /**
     * 更新
     */
    @PostMapping("/sfavisitroledirectory/update")
    Result update(@RequestBody SfaVisitRoleDirectoryReqVo sfaVisitRoleDirectoryReqVo);

    /**
     * 删除
     */
    @PostMapping("/sfavisitroledirectory/delete")
    Result delete(@RequestBody SfaVisitRoleDirectoryReqVo sfaVisitRoleDirectoryReqVo);

    /**
     * 启用
     */
    @PostMapping("/sfavisitroledirectory/enable")
    Result enable(@RequestBody SfaVisitRoleDirectoryReqVo sfaVisitRoleDirectoryReqVo);

    /**
     * 禁用
     */
    @PostMapping("/sfavisitroledirectory/disable")
    Result disable(@RequestBody SfaVisitRoleDirectoryReqVo sfaVisitRoleDirectoryReqVo);
}
