package com.biz.crm.sfa.collection.impl;

import com.biz.crm.base.BaseAbstract;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.sfa.collection.req.SfaDirectoryConfigReqVo;
import com.biz.crm.nebular.sfa.collection.resp.SfaDirectoryConfigRespVo;
import com.biz.crm.sfa.collection.SfaDirectoryConfigFeign;
import com.biz.crm.util.Result;
import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.util.ArrayList;

/**
 * 拜访步骤表单配置 feign接口熔断类
 *
 * @author liuhongming
 * @date 2020-09-18 10:33:32
 */
@Slf4j
@Component
public class SfaDirectoryConfigFeignImpl extends BaseAbstract implements FallbackFactory<SfaDirectoryConfigFeign> {

    @Override
    public SfaDirectoryConfigFeign create(Throwable throwable) {
        log.error("进入熔断",throwable);
        return new SfaDirectoryConfigFeign() {
             /**
              * 列表
              */
            @Override
            public Result<PageResult<SfaDirectoryConfigRespVo>> list(SfaDirectoryConfigReqVo sfaDirectoryConfigReqVo) {
                doBack();
                PageResult<SfaDirectoryConfigRespVo> build = PageResult.<SfaDirectoryConfigRespVo>builder()
                        .data(new ArrayList<>())
                        .count(0L)
                        .build();
                return Result.ok(build);
            }

            /**
             * 查询
             */
            @Override
            public Result<SfaDirectoryConfigRespVo> query(SfaDirectoryConfigReqVo sfaDirectoryConfigReqVo) {
                return doBack();
            }

            /**
             * 新增
             */
            @Override
            public Result save(SfaDirectoryConfigReqVo sfaDirectoryConfigReqVo) {
                return doBack();
            }

            /**
             * 更新
             */
            @Override
            public Result update(SfaDirectoryConfigReqVo sfaDirectoryConfigReqVo) {
                return doBack();
            }

            /**
             * 删除
             */
            @Override
            public Result delete(SfaDirectoryConfigReqVo sfaDirectoryConfigReqVo) {
                return doBack();
            }

            /**
             * 启用
             */
            @Override
            public Result enable(SfaDirectoryConfigReqVo sfaDirectoryConfigReqVo) {
                return doBack();
            }

            /**
             * 禁用
             */
            @Override
            public Result disable(SfaDirectoryConfigReqVo sfaDirectoryConfigReqVo) {
                return doBack();
            }
        };
    }
}
