package com.biz.crm.sfa.collection.impl;

import com.biz.crm.base.BaseAbstract;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.sfa.collection.req.SfaDirectoryInputReqVo;
import com.biz.crm.nebular.sfa.collection.resp.SfaDirectoryInputRespVo;
import com.biz.crm.sfa.collection.SfaDirectoryInputFeign;
import com.biz.crm.util.Result;
import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.util.ArrayList;

/**
 * 拜访步骤 -控件目录信息明细 feign接口熔断类
 *
 * @author liuhongming
 * @date 2020-09-18 10:33:33
 */
@Slf4j
@Component
public class SfaDirectoryInputFeignImpl extends BaseAbstract implements FallbackFactory<SfaDirectoryInputFeign> {

    @Override
    public SfaDirectoryInputFeign create(Throwable throwable) {
        log.error("进入熔断",throwable);
        return new SfaDirectoryInputFeign() {
             /**
              * 列表
              */
            @Override
            public Result<PageResult<SfaDirectoryInputRespVo>> list(SfaDirectoryInputReqVo sfaDirectoryInputReqVo) {
                doBack();
                PageResult<SfaDirectoryInputRespVo> build = PageResult.<SfaDirectoryInputRespVo>builder()
                        .data(new ArrayList<>())
                        .count(0L)
                        .build();
                return Result.ok(build);
            }

            /**
             * 查询
             */
            @Override
            public Result<SfaDirectoryInputRespVo> query(SfaDirectoryInputReqVo sfaDirectoryInputReqVo) {
                return doBack();
            }

            /**
             * 新增
             */
            @Override
            public Result save(SfaDirectoryInputReqVo sfaDirectoryInputReqVo) {
                return doBack();
            }

            /**
             * 更新
             */
            @Override
            public Result update(SfaDirectoryInputReqVo sfaDirectoryInputReqVo) {
                return doBack();
            }

            /**
             * 删除
             */
            @Override
            public Result delete(SfaDirectoryInputReqVo sfaDirectoryInputReqVo) {
                return doBack();
            }

            /**
             * 启用
             */
            @Override
            public Result enable(SfaDirectoryInputReqVo sfaDirectoryInputReqVo) {
                return doBack();
            }

            /**
             * 禁用
             */
            @Override
            public Result disable(SfaDirectoryInputReqVo sfaDirectoryInputReqVo) {
                return doBack();
            }
        };
    }
}
