package com.biz.crm.sfa.collection.impl;

import com.biz.crm.base.BaseAbstract;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.sfa.collection.req.SfaVisitRoleConfigReqVo;
import com.biz.crm.nebular.sfa.collection.resp.SfaVisitRoleConfigRespVo;
import com.biz.crm.sfa.collection.SfaVisitRoleConfigFeign;
import com.biz.crm.util.Result;
import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.util.ArrayList;

/**
 * 拜访步骤配置(角色) feign接口熔断类
 *
 * @author liuhongming
 * @date 2020-09-18 14:49:32
 */
@Slf4j
@Component
public class SfaVisitRoleConfigFeignImpl extends BaseAbstract implements FallbackFactory<SfaVisitRoleConfigFeign> {

    @Override
    public SfaVisitRoleConfigFeign create(Throwable throwable) {
        log.error("进入熔断",throwable);
        return new SfaVisitRoleConfigFeign() {
             /**
              * 列表
              */
            @Override
            public Result<PageResult<SfaVisitRoleConfigRespVo>> list(SfaVisitRoleConfigReqVo sfaVisitRoleConfigReqVo) {
                doBack();
                PageResult<SfaVisitRoleConfigRespVo> build = PageResult.<SfaVisitRoleConfigRespVo>builder()
                        .data(new ArrayList<>())
                        .count(0L)
                        .build();
                return Result.ok(build);
            }

            /**
             * 查询
             */
            @Override
            public Result<SfaVisitRoleConfigRespVo> query(SfaVisitRoleConfigReqVo sfaVisitRoleConfigReqVo) {
                return doBack();
            }

            /**
             * 新增
             */
            @Override
            public Result save(SfaVisitRoleConfigReqVo sfaVisitRoleConfigReqVo) {
                return doBack();
            }

            /**
             * 更新
             */
            @Override
            public Result update(SfaVisitRoleConfigReqVo sfaVisitRoleConfigReqVo) {
                return doBack();
            }

            /**
             * 删除
             */
            @Override
            public Result delete(SfaVisitRoleConfigReqVo sfaVisitRoleConfigReqVo) {
                return doBack();
            }

            /**
             * 启用
             */
            @Override
            public Result enable(SfaVisitRoleConfigReqVo sfaVisitRoleConfigReqVo) {
                return doBack();
            }

            /**
             * 禁用
             */
            @Override
            public Result disable(SfaVisitRoleConfigReqVo sfaVisitRoleConfigReqVo) {
                return doBack();
            }
        };
    }
}
