package com.biz.crm.sfa.freesignconfig;

import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.sfa.freesignconfig.req.SfaFreesignConfigReqVo;
import com.biz.crm.nebular.sfa.freesignconfig.resp.SfaFreesignConfigRespVo;
import com.biz.crm.sfa.freesignconfig.impl.SfaFreesignConfigFeignImpl;
import com.biz.crm.util.Result;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * 签到组 feign接口
 *
 * @author liuhongming
 * @date 2020-09-17 14:40:27
 */


@FeignClient(url ="${feign.urlip:}",qualifier = "SfaFreesignConfigFeign",name="crm-sfa",path = "sfa",fallbackFactory = SfaFreesignConfigFeignImpl.class)
public interface SfaFreesignConfigFeign {

    /**
     * 列表
     */
    @PostMapping("/sfafreesignconfig/list")
    Result<PageResult<SfaFreesignConfigRespVo>> list(@RequestBody SfaFreesignConfigReqVo sfaFreesignConfigReqVo);

    /**
     * 查询
     */
    @PostMapping("/sfafreesignconfig/query")
    Result<SfaFreesignConfigRespVo> query(@RequestBody SfaFreesignConfigReqVo sfaFreesignConfigReqVo);

    /**
     * 新增
     */
    @PostMapping("/sfafreesignconfig/save")
    Result save(@RequestBody SfaFreesignConfigReqVo sfaFreesignConfigReqVo);

    /**
     * 更新
     */
    @PostMapping("/sfafreesignconfig/update")
    Result update(@RequestBody SfaFreesignConfigReqVo sfaFreesignConfigReqVo);

    /**
     * 删除
     */
    @PostMapping("/sfafreesignconfig/delete")
    Result delete(@RequestBody SfaFreesignConfigReqVo sfaFreesignConfigReqVo);

    /**
     * 启用
     */
    @PostMapping("/sfafreesignconfig/enable")
    Result enable(@RequestBody SfaFreesignConfigReqVo sfaFreesignConfigReqVo);

    /**
     * 禁用
     */
    @PostMapping("/sfafreesignconfig/disable")
    Result disable(@RequestBody SfaFreesignConfigReqVo sfaFreesignConfigReqVo);
}
