package com.biz.crm.sfa.freesignconfig;

import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.sfa.freesignconfig.req.SfaFreesignSignTypeReqVo;
import com.biz.crm.nebular.sfa.freesignconfig.resp.SfaFreesignSignTypeRespVo;
import com.biz.crm.sfa.freesignconfig.impl.SfaFreesignSignTypeFeignImpl;
import com.biz.crm.util.Result;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
/**
 * 签到组--打卡类型 feign接口
 *
 * @author liuhongming
 * @date 2020-09-17 14:40:27
 */


@FeignClient(url ="${feign.urlip:}",qualifier = "SfaFreesignSignTypeFeign",name="crm-sfa",path = "sfa",fallbackFactory = SfaFreesignSignTypeFeignImpl.class)
public interface SfaFreesignSignTypeFeign {

    /**
     * 列表
     */
    @PostMapping("/sfafreesignsigntype/list")
    Result<PageResult<SfaFreesignSignTypeRespVo>> list(@RequestBody SfaFreesignSignTypeReqVo sfaFreesignSignTypeReqVo);

    /**
     * 查询
     */
    @PostMapping("/sfafreesignsigntype/query")
    Result<SfaFreesignSignTypeRespVo> query(@RequestBody SfaFreesignSignTypeReqVo sfaFreesignSignTypeReqVo);

    /**
     * 新增
     */
    @PostMapping("/sfafreesignsigntype/save")
    Result save(@RequestBody SfaFreesignSignTypeReqVo sfaFreesignSignTypeReqVo);

    /**
     * 更新
     */
    @PostMapping("/sfafreesignsigntype/update")
    Result update(@RequestBody SfaFreesignSignTypeReqVo sfaFreesignSignTypeReqVo);

    /**
     * 删除
     */
    @PostMapping("/sfafreesignsigntype/delete")
    Result delete(@RequestBody SfaFreesignSignTypeReqVo sfaFreesignSignTypeReqVo);

    /**
     * 启用
     */
    @PostMapping("/sfafreesignsigntype/enable")
    Result enable(@RequestBody SfaFreesignSignTypeReqVo sfaFreesignSignTypeReqVo);

    /**
     * 禁用
     */
    @PostMapping("/sfafreesignsigntype/disable")
    Result disable(@RequestBody SfaFreesignSignTypeReqVo sfaFreesignSignTypeReqVo);
}
