package com.biz.crm.sfa.map.impl;

import com.biz.crm.base.BaseAbstract;
import com.biz.crm.common.PageResult;
import com.biz.crm.gaode.vo.AmapPoiQueryReqVo;
import com.biz.crm.gaode.vo.AmapPoiResultVo;
import com.biz.crm.gaode.vo.GaodeNearbyVo;
import com.biz.crm.gaode.vo.QueryAroundVo;
import com.biz.crm.nebular.sfa.notice.req.SfaNoticeReqVo;
import com.biz.crm.nebular.sfa.notice.resp.SfaNoticeRespVo;
import com.biz.crm.sfa.map.GaoDeFeign;
import com.biz.crm.sfa.notice.SfaNoticeFeign;
import com.biz.crm.util.Result;
import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.util.ArrayList;

/**
 * 高德地图Api feign接口
 *
 * @author yangshan
 * @date 2021-3-9 15:28:27
 */
@Slf4j
@Component
public class GaoDeFeignImpl extends BaseAbstract implements FallbackFactory<GaoDeFeign> {

    @Override
    public GaoDeFeign create(Throwable throwable) {
        log.error("进入熔断",throwable);
        return new GaoDeFeign() {

            @Override
            public Result<PageResult<GaodeNearbyVo>> queryAround(QueryAroundVo queryAroundVo) {
                doBack();
                PageResult<GaodeNearbyVo> build = PageResult.<GaodeNearbyVo>builder()
                        .data(new ArrayList<>())
                        .count(0L)
                        .build();
                return Result.ok(build);
            }

            @Override
            public Result<AmapPoiResultVo> queryKeywords(AmapPoiQueryReqVo reqVo) {
                return doBack();
            }
        };
    }
}
