package com.biz.crm.sfa.moblie;

import com.biz.crm.activiti.common.CallbackFeign;
import com.biz.crm.nebular.activiti.act.ActivitiCallBackVo;
import com.biz.crm.sfa.moblie.impl.SfaCustomerFeignImpl;
import com.biz.crm.util.Result;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;

/**
 * 客户审批流程结束回调
 * @author YuanZiJian
 * @date 2021/1/4 13:50
 * @version: V1.0
 */

@FeignClient(url ="${feign.urlip:}",qualifier = "SfaCustomerFeign"
        ,name="crm-sfa",path = "sfa",fallbackFactory = SfaCustomerFeignImpl.class)
public interface SfaCustomerFeign extends CallbackFeign {
    /**
     * 客户流程结束
     * @param activitiCallBackVo
     * @return
     */
    @PostMapping("/client/customerEnd")
    Result callback(ActivitiCallBackVo activitiCallBackVo);
}
