package com.biz.crm.sfa.notice.impl;

import com.biz.crm.base.BaseAbstract;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.sfa.notice.req.SfaNoticeReadReqVo;
import com.biz.crm.nebular.sfa.notice.resp.SfaNoticeReadRespVo;
import com.biz.crm.sfa.notice.SfaNoticeReadFeign;
import com.biz.crm.util.Result;
import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.util.ArrayList;

/**
 * 公告读取信息 feign接口熔断类
 *
 * @author liuhongming
 * @date 2020-09-17 19:12:50
 */
@Slf4j
@Component
public class SfaNoticeReadFeignImpl extends BaseAbstract implements FallbackFactory<SfaNoticeReadFeign> {

    @Override
    public SfaNoticeReadFeign create(Throwable throwable) {
        log.error("进入熔断",throwable);
        return new SfaNoticeReadFeign() {
             /**
              * 列表
              */
            @Override
            public Result<PageResult<SfaNoticeReadRespVo>> list(SfaNoticeReadReqVo sfaNoticeReadReqVo) {
                doBack();
                PageResult<SfaNoticeReadRespVo> build = PageResult.<SfaNoticeReadRespVo>builder()
                        .data(new ArrayList<>())
                        .count(0L)
                        .build();
                return Result.ok(build);
            }

            /**
             * 查询
             */
            @Override
            public Result<SfaNoticeReadRespVo> query(SfaNoticeReadReqVo sfaNoticeReadReqVo) {
                return doBack();
            }

            /**
             * 新增
             */
            @Override
            public Result save(SfaNoticeReadReqVo sfaNoticeReadReqVo) {
                return doBack();
            }

            /**
             * 更新
             */
            @Override
            public Result update(SfaNoticeReadReqVo sfaNoticeReadReqVo) {
                return doBack();
            }

            /**
             * 删除
             */
            @Override
            public Result delete(SfaNoticeReadReqVo sfaNoticeReadReqVo) {
                return doBack();
            }

            /**
             * 启用
             */
            @Override
            public Result enable(SfaNoticeReadReqVo sfaNoticeReadReqVo) {
                return doBack();
            }

            /**
             * 禁用
             */
            @Override
            public Result disable(SfaNoticeReadReqVo sfaNoticeReadReqVo) {
                return doBack();
            }
        };
    }
}
