package com.biz.crm.sfa.visitdealer.impl;

import com.biz.crm.base.BaseAbstract;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.mdm.customer.MdmCustomerCountReqVo;
import com.biz.crm.nebular.sfa.visitdealer.req.SfaVisitDealerDetailReqVo;
import com.biz.crm.nebular.sfa.visitdealer.resp.SfaVisitDealerDetailRespVo;
import com.biz.crm.sfa.visitdealer.SfaVisitDealerDetailFeign;
import com.biz.crm.util.Result;
import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.util.ArrayList;

/**
 * 经销商拜访明细;feign接口熔断类
 *
 * @author lf
 * @date 2020-11-17 11:22:50
 */
@Slf4j
@Component
public class SfaVisitDealerDetailFeignImpl extends BaseAbstract implements FallbackFactory<SfaVisitDealerDetailFeign> {

    @Override
    public SfaVisitDealerDetailFeign create(Throwable throwable) {
        log.error("进入熔断",throwable);
        return new SfaVisitDealerDetailFeign() {
             /**
              * 列表
              */
            @Override
            public Result<PageResult<SfaVisitDealerDetailRespVo>> list(SfaVisitDealerDetailReqVo sfaVisitDealerDetailReqVo) {
                doBack();
                PageResult<SfaVisitDealerDetailRespVo> build = PageResult.<SfaVisitDealerDetailRespVo>builder()
                        .data(new ArrayList<>())
                        .count(0L)
                        .build();
                return Result.ok(build);
            }

            /**
             * 查询
             */
            @Override
            public Result<SfaVisitDealerDetailRespVo> query(SfaVisitDealerDetailReqVo sfaVisitDealerDetailReqVo) {
                return doBack();
            }

            /**
             * 新增
             */
            @Override
            public Result save(SfaVisitDealerDetailReqVo sfaVisitDealerDetailReqVo) {
                return doBack();
            }

            /**
             * 更新
             */
            @Override
            public Result update(SfaVisitDealerDetailReqVo sfaVisitDealerDetailReqVo) {
                return doBack();
            }

            /**
             * 删除
             */
            @Override
            public Result delete(SfaVisitDealerDetailReqVo sfaVisitDealerDetailReqVo) {
                return doBack();
            }

            /**
             * 启用
             */
            @Override
            public Result enable(SfaVisitDealerDetailReqVo sfaVisitDealerDetailReqVo) {
                return doBack();
            }

            /**
             * 禁用
             */
            @Override
            public Result disable(SfaVisitDealerDetailReqVo sfaVisitDealerDetailReqVo) {
                return doBack();
            }

            /**
             * 查询本期 对应拜访数
             * @param reqVo
             * @return
             */
            @Override
            public Result findVisitNumber(MdmCustomerCountReqVo reqVo){
                return doBack();
            }

        };
    }
}
