package com.biz.crm.sfa.visitdealer.impl;

import com.biz.crm.base.BaseAbstract;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.sfa.visitdealer.req.SfaVisitDealerMonthlyReportReqVo;
import com.biz.crm.nebular.sfa.visitdealer.resp.SfaVisitDealerMonthlyReportRespVo;
import com.biz.crm.sfa.visitdealer.SfaVisitDealerMonthlyReportFeign;
import com.biz.crm.util.Result;
import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.util.ArrayList;

/**
 * 经销商拜访月度报表;feign接口熔断类
 *
 * @author lf
 * @date 2020-11-20 11:21:59
 */
@Slf4j
@Component
public class SfaVisitDealerMonthlyReportFeignImpl extends BaseAbstract implements FallbackFactory<SfaVisitDealerMonthlyReportFeign> {

    @Override
    public SfaVisitDealerMonthlyReportFeign create(Throwable throwable) {
        log.error("进入熔断",throwable);
        return new SfaVisitDealerMonthlyReportFeign() {
             /**
              * 列表
              */
            @Override
            public Result<PageResult<SfaVisitDealerMonthlyReportRespVo>> list(SfaVisitDealerMonthlyReportReqVo sfaVisitDealerMonthlyReportReqVo) {
                doBack();
                PageResult<SfaVisitDealerMonthlyReportRespVo> build = PageResult.<SfaVisitDealerMonthlyReportRespVo>builder()
                        .data(new ArrayList<>())
                        .count(0L)
                        .build();
                return Result.ok(build);
            }

            /**
             * 查询
             */
            @Override
            public Result<SfaVisitDealerMonthlyReportRespVo> query(SfaVisitDealerMonthlyReportReqVo sfaVisitDealerMonthlyReportReqVo) {
                return doBack();
            }

            /**
             * 新增
             */
            @Override
            public Result save(SfaVisitDealerMonthlyReportReqVo sfaVisitDealerMonthlyReportReqVo) {
                return doBack();
            }

            /**
             * 更新
             */
            @Override
            public Result update(SfaVisitDealerMonthlyReportReqVo sfaVisitDealerMonthlyReportReqVo) {
                return doBack();
            }

            /**
             * 删除
             */
            @Override
            public Result delete(SfaVisitDealerMonthlyReportReqVo sfaVisitDealerMonthlyReportReqVo) {
                return doBack();
            }

            /**
             * 启用
             */
            @Override
            public Result enable(SfaVisitDealerMonthlyReportReqVo sfaVisitDealerMonthlyReportReqVo) {
                return doBack();
            }

            /**
             * 禁用
             */
            @Override
            public Result disable(SfaVisitDealerMonthlyReportReqVo sfaVisitDealerMonthlyReportReqVo) {
                return doBack();
            }

            @Override
            public Result produceVisitDetailReport(SfaVisitDealerMonthlyReportReqVo sfaVisitDealerMonthlyReportReqVo) {
                return null;
            }
        };
    }
}
