package com.biz.crm.sfa.visitnote;

import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.sfa.visitnote.req.SfaVisitGroupReqVo;
import com.biz.crm.nebular.sfa.visitnote.resp.SfaVisitGroupRespVo;
import com.biz.crm.sfa.visitnote.impl.SfaVisitGroupFeignImpl;
import com.biz.crm.util.Result;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * 线路组管理 feign接口
 *
 * @author liuhongming
 * @date 2020-09-18 16:53:00
 */


@FeignClient(url ="${feign.urlip:}",qualifier = "SfaVisitGroupFeign",name="crm-sfa",path = "sfa",fallbackFactory = SfaVisitGroupFeignImpl.class)
public interface SfaVisitGroupFeign {

    /**
     * 列表
     */
    @PostMapping("/sfavisitgroup/list")
    Result<PageResult<SfaVisitGroupRespVo>> list(@RequestBody SfaVisitGroupReqVo sfaVisitGroupReqVo);

    /**
     * 查询
     */
    @PostMapping("/sfavisitgroup/query")
    Result<SfaVisitGroupRespVo> query(@RequestBody SfaVisitGroupReqVo sfaVisitGroupReqVo);

    /**
     * 新增
     */
    @PostMapping("/sfavisitgroup/save")
    Result save(@RequestBody SfaVisitGroupReqVo sfaVisitGroupReqVo);

    /**
     * 更新
     */
    @PostMapping("/sfavisitgroup/update")
    Result update(@RequestBody SfaVisitGroupReqVo sfaVisitGroupReqVo);

    /**
     * 删除
     */
    @PostMapping("/sfavisitgroup/delete")
    Result delete(@RequestBody SfaVisitGroupReqVo sfaVisitGroupReqVo);

    /**
     * 启用
     */
    @PostMapping("/sfavisitgroup/enable")
    Result enable(@RequestBody SfaVisitGroupReqVo sfaVisitGroupReqVo);

    /**
     * 禁用
     */
    @PostMapping("/sfavisitgroup/disable")
    Result disable(@RequestBody SfaVisitGroupReqVo sfaVisitGroupReqVo);
}
