package com.biz.crm.sfa.visitnote;

import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.sfa.visitnote.req.SfaVisitTempPlanReqVo;
import com.biz.crm.nebular.sfa.visitnote.resp.SfaVisitTempPlanRespVo;
import com.biz.crm.sfa.visitnote.impl.SfaVisitTempPlanFeignImpl;
import com.biz.crm.util.Result;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * 临时拜访计划制定 feign接口
 *
 * @author liuhongming
 * @date 2020-09-21 14:35:05
 */


@FeignClient(url ="${feign.urlip:}",qualifier = "SfaVisitTempPlanFeign",name="crm-sfa",path = "sfa",fallbackFactory = SfaVisitTempPlanFeignImpl.class)
public interface SfaVisitTempPlanFeign {

    /**
     * 列表
     */
    @PostMapping("/sfavisittempplan/list")
    Result<PageResult<SfaVisitTempPlanRespVo>> list(@RequestBody SfaVisitTempPlanReqVo sfaVisitTempPlanReqVo);

    /**
     * 查询
     */
    @PostMapping("/sfavisittempplan/query")
    Result<SfaVisitTempPlanRespVo> query(@RequestBody SfaVisitTempPlanReqVo sfaVisitTempPlanReqVo);

    /**
     * 新增
     */
    @PostMapping("/sfavisittempplan/save")
    Result save(@RequestBody SfaVisitTempPlanReqVo sfaVisitTempPlanReqVo);

    /**
     * 更新
     */
    @PostMapping("/sfavisittempplan/update")
    Result update(@RequestBody SfaVisitTempPlanReqVo sfaVisitTempPlanReqVo);

    /**
     * 删除
     */
    @PostMapping("/sfavisittempplan/delete")
    Result delete(@RequestBody SfaVisitTempPlanReqVo sfaVisitTempPlanReqVo);

    /**
     * 启用
     */
    @PostMapping("/sfavisittempplan/enable")
    Result enable(@RequestBody SfaVisitTempPlanReqVo sfaVisitTempPlanReqVo);

    /**
     * 禁用
     */
    @PostMapping("/sfavisittempplan/disable")
    Result disable(@RequestBody SfaVisitTempPlanReqVo sfaVisitTempPlanReqVo);
}
