package com.biz.crm.sfa.visitnote;

import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.sfa.visitnote.req.SfaVisitclientRelReqVo;
import com.biz.crm.nebular.sfa.visitnote.resp.SfaVisitclientRelRespVo;
import com.biz.crm.sfa.visitnote.impl.SfaVisitclientRelFeignImpl;
import com.biz.crm.util.Result;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * 线路组对应客户信息 feign接口
 *
 * @author liuhongming
 * @date 2020-09-18 16:53:00
 */


@FeignClient(url ="${feign.urlip:}",qualifier = "SfaVisitclientRelFeign",name="crm-sfa",path = "sfa",fallbackFactory = SfaVisitclientRelFeignImpl.class)
public interface SfaVisitclientRelFeign {

    /**
     * 列表
     */
    @PostMapping("/sfavisitclientrel/list")
    Result<PageResult<SfaVisitclientRelRespVo>> list(@RequestBody SfaVisitclientRelReqVo sfaVisitclientRelReqVo);

    /**
     * 查询
     */
    @PostMapping("/sfavisitclientrel/query")
    Result<SfaVisitclientRelRespVo> query(@RequestBody SfaVisitclientRelReqVo sfaVisitclientRelReqVo);

    /**
     * 新增
     */
    @PostMapping("/sfavisitclientrel/save")
    Result save(@RequestBody SfaVisitclientRelReqVo sfaVisitclientRelReqVo);

    /**
     * 更新
     */
    @PostMapping("/sfavisitclientrel/update")
    Result update(@RequestBody SfaVisitclientRelReqVo sfaVisitclientRelReqVo);

    /**
     * 删除
     */
    @PostMapping("/sfavisitclientrel/delete")
    Result delete(@RequestBody SfaVisitclientRelReqVo sfaVisitclientRelReqVo);

    /**
     * 启用
     */
    @PostMapping("/sfavisitclientrel/enable")
    Result enable(@RequestBody SfaVisitclientRelReqVo sfaVisitclientRelReqVo);

    /**
     * 禁用
     */
    @PostMapping("/sfavisitclientrel/disable")
    Result disable(@RequestBody SfaVisitclientRelReqVo sfaVisitclientRelReqVo);
}
