package com.biz.crm.sfa.visitnote.impl;

import com.biz.crm.base.BaseAbstract;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.sfa.visitnote.req.SfaVisitTempPlanReqVo;
import com.biz.crm.nebular.sfa.visitnote.resp.SfaVisitPlanRespVo;
import com.biz.crm.nebular.sfa.visitnote.resp.SfaVisitTempPlanRespVo;
import com.biz.crm.sfa.visitnote.SfaVisitTempPlanFeign;
import com.biz.crm.util.Result;
import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.util.ArrayList;

/**
 * 临时拜访计划制定 feign接口熔断类
 *
 * @author liuhongming
 * @date 2020-09-21 14:35:05
 */
@Slf4j
@Component
public class SfaVisitTempPlanFeignImpl extends BaseAbstract implements FallbackFactory<SfaVisitTempPlanFeign> {

    @Override
    public SfaVisitTempPlanFeign create(Throwable throwable) {
        log.error("进入熔断",throwable);
        return new SfaVisitTempPlanFeign() {
             /**
              * 列表
              */
            @Override
            public Result<PageResult<SfaVisitTempPlanRespVo>> list(SfaVisitTempPlanReqVo sfaVisitTempPlanReqVo) {
                doBack();
                PageResult<SfaVisitTempPlanRespVo> build = PageResult.<SfaVisitTempPlanRespVo>builder()
                        .data(new ArrayList<>())
                        .count(0L)
                        .build();
                return Result.ok(build);
            }

            /**
             * 查询
             */
            @Override
            public Result<SfaVisitTempPlanRespVo> query(SfaVisitTempPlanReqVo sfaVisitTempPlanReqVo) {
                return doBack();
            }

            /**
             * 新增
             */
            @Override
            public Result save(SfaVisitTempPlanReqVo sfaVisitTempPlanReqVo) {
                return doBack();
            }

            /**
             * 更新
             */
            @Override
            public Result update(SfaVisitTempPlanReqVo sfaVisitTempPlanReqVo) {
                return doBack();
            }

            /**
             * 删除
             */
            @Override
            public Result delete(SfaVisitTempPlanReqVo sfaVisitTempPlanReqVo) {
                return doBack();
            }

            /**
             * 启用
             */
            @Override
            public Result enable(SfaVisitTempPlanReqVo sfaVisitTempPlanReqVo) {
                return doBack();
            }

            /**
             * 禁用
             */
            @Override
            public Result disable(SfaVisitTempPlanReqVo sfaVisitTempPlanReqVo) {
                return doBack();
            }
        };
    }
}
