package com.biz.crm.sfa.visitnote.impl;

import com.biz.crm.base.BaseAbstract;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.sfa.visitnote.req.SfaVisitclientRelReqVo;
import com.biz.crm.nebular.sfa.visitnote.resp.SfaVisitclientRelRespVo;
import com.biz.crm.sfa.visitnote.SfaVisitclientRelFeign;
import com.biz.crm.util.Result;
import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.util.ArrayList;

/**
 * 线路组对应客户信息 feign接口熔断类
 *
 * @author liuhongming
 * @date 2020-09-18 16:53:00
 */
@Slf4j
@Component
public class SfaVisitclientRelFeignImpl extends BaseAbstract implements FallbackFactory<SfaVisitclientRelFeign> {

    @Override
    public SfaVisitclientRelFeign create(Throwable throwable) {
        log.error("进入熔断",throwable);
        return new SfaVisitclientRelFeign() {
             /**
              * 列表
              */
            @Override
            public Result<PageResult<SfaVisitclientRelRespVo>> list(SfaVisitclientRelReqVo sfaVisitclientRelReqVo) {
                doBack();
                PageResult<SfaVisitclientRelRespVo> build = PageResult.<SfaVisitclientRelRespVo>builder()
                        .data(new ArrayList<>())
                        .count(0L)
                        .build();
                return Result.ok(build);
            }

            /**
             * 查询
             */
            @Override
            public Result<SfaVisitclientRelRespVo> query(SfaVisitclientRelReqVo sfaVisitclientRelReqVo) {
                return doBack();
            }

            /**
             * 新增
             */
            @Override
            public Result save(SfaVisitclientRelReqVo sfaVisitclientRelReqVo) {
                return doBack();
            }

            /**
             * 更新
             */
            @Override
            public Result update(SfaVisitclientRelReqVo sfaVisitclientRelReqVo) {
                return doBack();
            }

            /**
             * 删除
             */
            @Override
            public Result delete(SfaVisitclientRelReqVo sfaVisitclientRelReqVo) {
                return doBack();
            }

            /**
             * 启用
             */
            @Override
            public Result enable(SfaVisitclientRelReqVo sfaVisitclientRelReqVo) {
                return doBack();
            }

            /**
             * 禁用
             */
            @Override
            public Result disable(SfaVisitclientRelReqVo sfaVisitclientRelReqVo) {
                return doBack();
            }
        };
    }
}
