package com.biz.crm.sfa.visitstep;

import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.sfa.visitstep.req.SfaVisitStepColletReqVo;
import com.biz.crm.nebular.sfa.visitstep.resp.SfaVisitStepColletRespVo;
import com.biz.crm.sfa.visitstep.impl.SfaVisitStepColletFeignImpl;
import com.biz.crm.util.Result;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * 拜访步骤(竞品采集);feign接口
 *
 * @author liuhongming
 * @date 2020-10-13 15:58:45
 */


@FeignClient(url ="${feign.urlip:}",qualifier = "SfaVisitStepColletFeign",name="crm-sfa",path = "sfa",fallbackFactory = SfaVisitStepColletFeignImpl.class)
public interface SfaVisitStepColletFeign {

    /**
     * 列表
     */
    @PostMapping("/sfavisitstepcollet/list")
    Result<PageResult<SfaVisitStepColletRespVo>> list(@RequestBody SfaVisitStepColletReqVo sfaVisitStepColletReqVo);

    /**
     * 查询
     */
    @PostMapping("/sfavisitstepcollet/query")
    Result<SfaVisitStepColletRespVo> query(@RequestBody SfaVisitStepColletReqVo sfaVisitStepColletReqVo);

    /**
     * 新增
     */
    @PostMapping("/sfavisitstepcollet/save")
    Result save(@RequestBody SfaVisitStepColletReqVo sfaVisitStepColletReqVo);

    /**
     * 更新
     */
    @PostMapping("/sfavisitstepcollet/update")
    Result update(@RequestBody SfaVisitStepColletReqVo sfaVisitStepColletReqVo);

    /**
     * 删除
     */
    @PostMapping("/sfavisitstepcollet/delete")
    Result delete(@RequestBody SfaVisitStepColletReqVo sfaVisitStepColletReqVo);

    /**
     * 启用
     */
    @PostMapping("/sfavisitstepcollet/enable")
    Result enable(@RequestBody SfaVisitStepColletReqVo sfaVisitStepColletReqVo);

    /**
     * 禁用
     */
    @PostMapping("/sfavisitstepcollet/disable")
    Result disable(@RequestBody SfaVisitStepColletReqVo sfaVisitStepColletReqVo);
}
