package com.biz.crm.sfa.visitstep;

import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.sfa.visitstep.req.SfaVisitStepColletItemReqVo;
import com.biz.crm.nebular.sfa.visitstep.resp.SfaVisitStepColletItemRespVo;
import com.biz.crm.sfa.visitstep.impl.SfaVisitStepColletItemFeignImpl;
import com.biz.crm.util.Result;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * 拜访步骤(竞品采集明细) feign接口
 *
 * @author liuhongming
 * @date 2020-10-13 15:58:45
 */


@FeignClient(url ="${feign.urlip:}",qualifier = "SfaVisitStepColletItemFeign",name="crm-sfa",path = "sfa",fallbackFactory = SfaVisitStepColletItemFeignImpl.class)
public interface SfaVisitStepColletItemFeign {

    /**
     * 列表
     */
    @PostMapping("/sfavisitstepcolletitem/list")
    Result<PageResult<SfaVisitStepColletItemRespVo>> list(@RequestBody SfaVisitStepColletItemReqVo sfaVisitStepColletItemReqVo);

    /**
     * 查询
     */
    @PostMapping("/sfavisitstepcolletitem/query")
    Result<SfaVisitStepColletItemRespVo> query(@RequestBody SfaVisitStepColletItemReqVo sfaVisitStepColletItemReqVo);

    /**
     * 新增
     */
    @PostMapping("/sfavisitstepcolletitem/save")
    Result save(@RequestBody SfaVisitStepColletItemReqVo sfaVisitStepColletItemReqVo);

    /**
     * 更新
     */
    @PostMapping("/sfavisitstepcolletitem/update")
    Result update(@RequestBody SfaVisitStepColletItemReqVo sfaVisitStepColletItemReqVo);

    /**
     * 删除
     */
    @PostMapping("/sfavisitstepcolletitem/delete")
    Result delete(@RequestBody SfaVisitStepColletItemReqVo sfaVisitStepColletItemReqVo);

    /**
     * 启用
     */
    @PostMapping("/sfavisitstepcolletitem/enable")
    Result enable(@RequestBody SfaVisitStepColletItemReqVo sfaVisitStepColletItemReqVo);

    /**
     * 禁用
     */
    @PostMapping("/sfavisitstepcolletitem/disable")
    Result disable(@RequestBody SfaVisitStepColletItemReqVo sfaVisitStepColletItemReqVo);
}
