package com.biz.crm.sfa.visitstep;

import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.sfa.visitstep.req.SfaVisitStepOrderReqVo;
import com.biz.crm.nebular.sfa.visitstep.resp.SfaVisitStepOrderRespVo;
import com.biz.crm.sfa.visitstep.impl.SfaVisitStepOrderFeignImpl;
import com.biz.crm.util.Result;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * 拜访步骤(订单主表);feign接口
 *
 * @author liuhongming
 * @date 2020-10-13 15:58:45
 */


@FeignClient(url ="${feign.urlip:}",qualifier = "SfaVisitStepOrderFeign",name="crm-sfa",path = "sfa",fallbackFactory = SfaVisitStepOrderFeignImpl.class)
public interface SfaVisitStepOrderFeign {

    /**
     * 列表
     */
    @PostMapping("/sfavisitsteporder/list")
    Result<PageResult<SfaVisitStepOrderRespVo>> list(@RequestBody SfaVisitStepOrderReqVo sfaVisitStepOrderReqVo);

    /**
     * 查询
     */
    @PostMapping("/sfavisitsteporder/query")
    Result<SfaVisitStepOrderRespVo> query(@RequestBody SfaVisitStepOrderReqVo sfaVisitStepOrderReqVo);

    /**
     * 新增
     */
    @PostMapping("/sfavisitsteporder/save")
    Result save(@RequestBody SfaVisitStepOrderReqVo sfaVisitStepOrderReqVo);

    /**
     * 更新
     */
    @PostMapping("/sfavisitsteporder/update")
    Result update(@RequestBody SfaVisitStepOrderReqVo sfaVisitStepOrderReqVo);

    /**
     * 删除
     */
    @PostMapping("/sfavisitsteporder/delete")
    Result delete(@RequestBody SfaVisitStepOrderReqVo sfaVisitStepOrderReqVo);

    /**
     * 启用
     */
    @PostMapping("/sfavisitsteporder/enable")
    Result enable(@RequestBody SfaVisitStepOrderReqVo sfaVisitStepOrderReqVo);

    /**
     * 禁用
     */
    @PostMapping("/sfavisitsteporder/disable")
    Result disable(@RequestBody SfaVisitStepOrderReqVo sfaVisitStepOrderReqVo);
}
