package com.biz.crm.sfa.visitstep;

import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.sfa.visitstep.req.SfaVisitStepOrderItemReqVo;
import com.biz.crm.nebular.sfa.visitstep.resp.SfaVisitStepOrderItemRespVo;
import com.biz.crm.sfa.visitstep.impl.SfaVisitStepOrderItemFeignImpl;
import com.biz.crm.util.Result;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * 拜访步骤(订单明细);feign接口
 *
 * @author liuhongming
 * @date 2020-10-13 15:58:45
 */


@FeignClient(url ="${feign.urlip:}",qualifier = "SfaVisitStepOrderItemFeign",name="crm-sfa",path = "sfa",fallbackFactory = SfaVisitStepOrderItemFeignImpl.class)
public interface SfaVisitStepOrderItemFeign {

    /**
     * 列表
     */
    @PostMapping("/sfavisitsteporderitem/list")
    Result<PageResult<SfaVisitStepOrderItemRespVo>> list(@RequestBody SfaVisitStepOrderItemReqVo sfaVisitStepOrderItemReqVo);

    /**
     * 查询
     */
    @PostMapping("/sfavisitsteporderitem/query")
    Result<SfaVisitStepOrderItemRespVo> query(@RequestBody SfaVisitStepOrderItemReqVo sfaVisitStepOrderItemReqVo);

    /**
     * 新增
     */
    @PostMapping("/sfavisitsteporderitem/save")
    Result save(@RequestBody SfaVisitStepOrderItemReqVo sfaVisitStepOrderItemReqVo);

    /**
     * 更新
     */
    @PostMapping("/sfavisitsteporderitem/update")
    Result update(@RequestBody SfaVisitStepOrderItemReqVo sfaVisitStepOrderItemReqVo);

    /**
     * 删除
     */
    @PostMapping("/sfavisitsteporderitem/delete")
    Result delete(@RequestBody SfaVisitStepOrderItemReqVo sfaVisitStepOrderItemReqVo);

    /**
     * 启用
     */
    @PostMapping("/sfavisitsteporderitem/enable")
    Result enable(@RequestBody SfaVisitStepOrderItemReqVo sfaVisitStepOrderItemReqVo);

    /**
     * 禁用
     */
    @PostMapping("/sfavisitsteporderitem/disable")
    Result disable(@RequestBody SfaVisitStepOrderItemReqVo sfaVisitStepOrderItemReqVo);
}
