package com.biz.crm.sfa.visitstep.impl;

import com.biz.crm.base.BaseAbstract;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.sfa.visitstep.req.SfaVisitStepActivityReqVo;
import com.biz.crm.nebular.sfa.visitstep.resp.SfaVisitStepActivityRespVo;
import com.biz.crm.sfa.visitstep.SfaVisitStepActivityFeign;
import com.biz.crm.util.Result;
import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.util.ArrayList;

/**
 * 拜访步骤(活动执行);feign接口熔断类
 *
 * @author liuhongming
 * @date 2020-10-13 15:58:45
 */
@Slf4j
@Component
public class SfaVisitStepActivityFeignImpl extends BaseAbstract implements FallbackFactory<SfaVisitStepActivityFeign> {

    @Override
    public SfaVisitStepActivityFeign create(Throwable throwable) {
        log.error("进入熔断",throwable);
        return new SfaVisitStepActivityFeign() {
             /**
              * 列表
              */
            @Override
            public Result<PageResult<SfaVisitStepActivityRespVo>> list(SfaVisitStepActivityReqVo sfaVisitStepActivityReqVo) {
                doBack();
                PageResult<SfaVisitStepActivityRespVo> build = PageResult.<SfaVisitStepActivityRespVo>builder()
                        .data(new ArrayList<>())
                        .count(0L)
                        .build();
                return Result.ok(build);
            }

            /**
             * 查询
             */
            @Override
            public Result<SfaVisitStepActivityRespVo> query(SfaVisitStepActivityReqVo sfaVisitStepActivityReqVo) {
                return doBack();
            }

            /**
             * 新增
             */
            @Override
            public Result save(SfaVisitStepActivityReqVo sfaVisitStepActivityReqVo) {
                return doBack();
            }

            /**
             * 更新
             */
            @Override
            public Result update(SfaVisitStepActivityReqVo sfaVisitStepActivityReqVo) {
                return doBack();
            }

            /**
             * 删除
             */
            @Override
            public Result delete(SfaVisitStepActivityReqVo sfaVisitStepActivityReqVo) {
                return doBack();
            }

            /**
             * 启用
             */
            @Override
            public Result enable(SfaVisitStepActivityReqVo sfaVisitStepActivityReqVo) {
                return doBack();
            }

            /**
             * 禁用
             */
            @Override
            public Result disable(SfaVisitStepActivityReqVo sfaVisitStepActivityReqVo) {
                return doBack();
            }
        };
    }
}
