package com.biz.crm.sfa.visitstep.impl;

import com.biz.crm.base.BaseAbstract;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.sfa.visitstep.req.SfaVisitStepInoutReqVo;
import com.biz.crm.nebular.sfa.visitstep.resp.SfaVisitStepInoutRespVo;
import com.biz.crm.sfa.visitstep.SfaVisitStepInoutFeign;
import com.biz.crm.util.Result;
import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.util.ArrayList;

/**
 * 拜访步骤(进离店) feign接口熔断类
 *
 * @author liuhongming
 * @date 2020-10-13 15:58:45
 */
@Slf4j
@Component
public class SfaVisitStepInoutFeignImpl extends BaseAbstract implements FallbackFactory<SfaVisitStepInoutFeign> {

    @Override
    public SfaVisitStepInoutFeign create(Throwable throwable) {
        log.error("进入熔断",throwable);
        return new SfaVisitStepInoutFeign() {
             /**
              * 列表
              */
            @Override
            public Result<PageResult<SfaVisitStepInoutRespVo>> list(SfaVisitStepInoutReqVo sfaVisitStepInoutReqVo) {
                doBack();
                PageResult<SfaVisitStepInoutRespVo> build = PageResult.<SfaVisitStepInoutRespVo>builder()
                        .data(new ArrayList<>())
                        .count(0L)
                        .build();
                return Result.ok(build);
            }

            /**
             * 查询
             */
            @Override
            public Result<SfaVisitStepInoutRespVo> query(SfaVisitStepInoutReqVo sfaVisitStepInoutReqVo) {
                return doBack();
            }

            /**
             * 新增
             */
            @Override
            public Result save(SfaVisitStepInoutReqVo sfaVisitStepInoutReqVo) {
                return doBack();
            }

            /**
             * 更新
             */
            @Override
            public Result update(SfaVisitStepInoutReqVo sfaVisitStepInoutReqVo) {
                return doBack();
            }

            /**
             * 删除
             */
            @Override
            public Result delete(SfaVisitStepInoutReqVo sfaVisitStepInoutReqVo) {
                return doBack();
            }

            /**
             * 启用
             */
            @Override
            public Result enable(SfaVisitStepInoutReqVo sfaVisitStepInoutReqVo) {
                return doBack();
            }

            /**
             * 禁用
             */
            @Override
            public Result disable(SfaVisitStepInoutReqVo sfaVisitStepInoutReqVo) {
                return doBack();
            }
        };
    }
}
