package com.biz.crm.sfa.visitstep.impl;

import com.biz.crm.base.BaseAbstract;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.sfa.visitstep.req.SfaVisitStepOrderReqVo;
import com.biz.crm.nebular.sfa.visitstep.resp.SfaVisitStepOrderRespVo;
import com.biz.crm.sfa.visitstep.SfaVisitStepOrderFeign;
import com.biz.crm.util.Result;
import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.util.ArrayList;

/**
 * 拜访步骤(订单主表);feign接口熔断类
 *
 * @author liuhongming
 * @date 2020-10-13 15:58:45
 */
@Slf4j
@Component
public class SfaVisitStepOrderFeignImpl extends BaseAbstract implements FallbackFactory<SfaVisitStepOrderFeign> {

    @Override
    public SfaVisitStepOrderFeign create(Throwable throwable) {
        log.error("进入熔断",throwable);
        return new SfaVisitStepOrderFeign() {
             /**
              * 列表
              */
            @Override
            public Result<PageResult<SfaVisitStepOrderRespVo>> list(SfaVisitStepOrderReqVo sfaVisitStepOrderReqVo) {
                doBack();
                PageResult<SfaVisitStepOrderRespVo> build = PageResult.<SfaVisitStepOrderRespVo>builder()
                        .data(new ArrayList<>())
                        .count(0L)
                        .build();
                return Result.ok(build);
            }

            /**
             * 查询
             */
            @Override
            public Result<SfaVisitStepOrderRespVo> query(SfaVisitStepOrderReqVo sfaVisitStepOrderReqVo) {
                return doBack();
            }

            /**
             * 新增
             */
            @Override
            public Result save(SfaVisitStepOrderReqVo sfaVisitStepOrderReqVo) {
                return doBack();
            }

            /**
             * 更新
             */
            @Override
            public Result update(SfaVisitStepOrderReqVo sfaVisitStepOrderReqVo) {
                return doBack();
            }

            /**
             * 删除
             */
            @Override
            public Result delete(SfaVisitStepOrderReqVo sfaVisitStepOrderReqVo) {
                return doBack();
            }

            /**
             * 启用
             */
            @Override
            public Result enable(SfaVisitStepOrderReqVo sfaVisitStepOrderReqVo) {
                return doBack();
            }

            /**
             * 禁用
             */
            @Override
            public Result disable(SfaVisitStepOrderReqVo sfaVisitStepOrderReqVo) {
                return doBack();
            }
        };
    }
}
