package com.biz.crm.sfa.visitstep.impl;

import com.biz.crm.base.BaseAbstract;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.sfa.visitstep.req.SfaVisitStepStockReqVo;
import com.biz.crm.nebular.sfa.visitstep.resp.SfaVisitStepStockRespVo;
import com.biz.crm.sfa.visitstep.SfaVisitStepStockFeign;
import com.biz.crm.util.Result;
import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.util.ArrayList;

/**
 * 拜访步骤(库存盘点);feign接口熔断类
 *
 * @author liuhongming
 * @date 2020-10-13 15:58:45
 */
@Slf4j
@Component
public class SfaVisitStepStockFeignImpl extends BaseAbstract implements FallbackFactory<SfaVisitStepStockFeign> {

    @Override
    public SfaVisitStepStockFeign create(Throwable throwable) {
        log.error("进入熔断",throwable);
        return new SfaVisitStepStockFeign() {
             /**
              * 列表
              */
            @Override
            public Result<PageResult<SfaVisitStepStockRespVo>> list(SfaVisitStepStockReqVo sfaVisitStepStockReqVo) {
                doBack();
                PageResult<SfaVisitStepStockRespVo> build = PageResult.<SfaVisitStepStockRespVo>builder()
                        .data(new ArrayList<>())
                        .count(0L)
                        .build();
                return Result.ok(build);
            }

            /**
             * 查询
             */
            @Override
            public Result<SfaVisitStepStockRespVo> query(SfaVisitStepStockReqVo sfaVisitStepStockReqVo) {
                return doBack();
            }

            /**
             * 新增
             */
            @Override
            public Result save(SfaVisitStepStockReqVo sfaVisitStepStockReqVo) {
                return doBack();
            }

            /**
             * 更新
             */
            @Override
            public Result update(SfaVisitStepStockReqVo sfaVisitStepStockReqVo) {
                return doBack();
            }

            /**
             * 删除
             */
            @Override
            public Result delete(SfaVisitStepStockReqVo sfaVisitStepStockReqVo) {
                return doBack();
            }

            /**
             * 启用
             */
            @Override
            public Result enable(SfaVisitStepStockReqVo sfaVisitStepStockReqVo) {
                return doBack();
            }

            /**
             * 禁用
             */
            @Override
            public Result disable(SfaVisitStepStockReqVo sfaVisitStepStockReqVo) {
                return doBack();
            }
        };
    }
}
