package com.biz.crm.sfa.worksign;

import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.sfa.worksign.req.SfaLeaveReqVo;
import com.biz.crm.nebular.sfa.worksign.resp.SfaLeaveRespVo;
import com.biz.crm.sfa.worksign.impl.SfaLeaveFeignImpl;
import com.biz.crm.util.Result;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * 请假申请 feign接口
 *
 * @author liuhongming
 * @date 2020-10-17 15:00:38
 */


@FeignClient(url ="${feign.urlip:}",qualifier = "SfaLeaveFeign",name="crm-sfa",path = "sfa",fallbackFactory = SfaLeaveFeignImpl.class)
public interface SfaLeaveFeign {

    /**
     * 列表
     */
    @PostMapping("/sfaleave/list")
    Result<PageResult<SfaLeaveRespVo>> list(@RequestBody SfaLeaveReqVo sfaLeaveReqVo);

    /**
     * 查询
     */
    @PostMapping("/sfaleave/query")
    Result<SfaLeaveRespVo> query(@RequestBody SfaLeaveReqVo sfaLeaveReqVo);

    /**
     * 新增
     */
    @PostMapping("/sfaleave/save")
    Result save(@RequestBody SfaLeaveReqVo sfaLeaveReqVo);

    /**
     * 更新
     */
    @PostMapping("/sfaleave/update")
    Result update(@RequestBody SfaLeaveReqVo sfaLeaveReqVo);

    /**
     * 删除
     */
    @PostMapping("/sfaleave/delete")
    Result delete(@RequestBody SfaLeaveReqVo sfaLeaveReqVo);

    /**
     * 启用
     */
    @PostMapping("/sfaleave/enable")
    Result enable(@RequestBody SfaLeaveReqVo sfaLeaveReqVo);

    /**
     * 禁用
     */
    @PostMapping("/sfaleave/disable")
    Result disable(@RequestBody SfaLeaveReqVo sfaLeaveReqVo);
}
