package com.biz.crm.sfa.worksign;

import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.sfa.worksign.req.SfaTravelReqVo;
import com.biz.crm.nebular.sfa.worksign.resp.SfaTravelRespVo;
import com.biz.crm.sfa.worksign.impl.SfaTravelFeignImpl;
import com.biz.crm.util.Result;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * 出差申请 feign接口
 *
 * @author liuhongming
 * @date 2020-10-17 15:00:38
 */


@FeignClient(url ="${feign.urlip:}",qualifier = "SfaTravelFeign",name="crm-sfa",path = "sfa",fallbackFactory = SfaTravelFeignImpl.class)
public interface SfaTravelFeign {

    /**
     * 列表
     */
    @PostMapping("/sfatravel/list")
    Result<PageResult<SfaTravelRespVo>> list(@RequestBody SfaTravelReqVo sfaTravelReqVo);

    /**
     * 查询
     */
    @PostMapping("/sfatravel/query")
    Result<SfaTravelRespVo> query(@RequestBody SfaTravelReqVo sfaTravelReqVo);

    /**
     * 新增
     */
    @PostMapping("/sfatravel/save")
    Result save(@RequestBody SfaTravelReqVo sfaTravelReqVo);

    /**
     * 更新
     */
    @PostMapping("/sfatravel/update")
    Result update(@RequestBody SfaTravelReqVo sfaTravelReqVo);

    /**
     * 删除
     */
    @PostMapping("/sfatravel/delete")
    Result delete(@RequestBody SfaTravelReqVo sfaTravelReqVo);

    /**
     * 启用
     */
    @PostMapping("/sfatravel/enable")
    Result enable(@RequestBody SfaTravelReqVo sfaTravelReqVo);

    /**
     * 禁用
     */
    @PostMapping("/sfatravel/disable")
    Result disable(@RequestBody SfaTravelReqVo sfaTravelReqVo);
}
