package com.biz.crm.sfa.worksign;

import com.biz.crm.activiti.common.CallbackFeign;
import com.biz.crm.nebular.activiti.act.ActivitiCallBackVo;
import com.biz.crm.sfa.worksign.impl.SfaWorkSignExceptionEndFeignImpl;
import com.biz.crm.util.Result;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;

/**
 * @author ren.gang
 * @ClassName SfaWorkSignExceptionEndFeign.java
 * @Description 异常报备流程结束
 * @createTime 2020年12月16日 10:15:00
 */
@FeignClient(url ="${feign.urlip:}",qualifier = "SfaWorkSignExceptionEndFeign"
        ,name="crm-sfa",path = "sfa",fallbackFactory = SfaWorkSignExceptionEndFeignImpl.class)
public interface SfaWorkSignExceptionEndFeign extends CallbackFeign {

    /**
     * 流程结束
     * @param activitiCallBackVo
     * @return
     */
    @PostMapping("/sfaWorkSignAudit/exceptionEnd")
    Result callback(ActivitiCallBackVo activitiCallBackVo);
}
