package com.biz.crm.sfa.worksign;

import com.biz.crm.activiti.common.CallbackFeign;
import com.biz.crm.nebular.activiti.act.ActivitiCallBackVo;
import com.biz.crm.sfa.worksign.impl.SfaWorkSignLeaveEndFeignImpl;
import com.biz.crm.util.Result;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;

/**
 * @author ren.gang
 * @ClassName SfaWorkSignLeaveEndFeign.java
 * @Description 请假流程结束
 * @createTime 2020年12月16日 10:14:00
 */
@FeignClient(url ="${feign.urlip:}",qualifier = "SfaWorkSignLeaveEndFeign"
        ,name="crm-sfa",path = "sfa",fallbackFactory = SfaWorkSignLeaveEndFeignImpl.class)
public interface SfaWorkSignLeaveEndFeign extends CallbackFeign {

    /**
     * 流程结束
     * @param activitiCallBackVo
     * @return
     */
    @PostMapping("/sfaWorkSignAudit/leaveEnd")
    Result callback(ActivitiCallBackVo activitiCallBackVo);
}
