package com.biz.crm.sfa.worksign;

import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.sfa.worksign.req.SfaWorkSignInfoReqVo;
import com.biz.crm.nebular.sfa.worksign.req.SfaWorkSignRuleInfoReqVo;
import com.biz.crm.nebular.sfa.worksign.resp.SfaWorkSignInfoRespVo;
import com.biz.crm.nebular.sfa.worksign.resp.SfaWorkSignRuleInfoRespVo;
import com.biz.crm.sfa.worksign.impl.SfaWorkSignRuleInfoFeignImpl;
import com.biz.crm.util.Result;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * 考勤规则明细表 feign接口
 *
 * @author liuhongming
 * @date 2020-10-14 15:05:08
 */


@FeignClient(url ="${feign.urlip:}",qualifier = "SfaWorkSignRuleInfoFeign",name="crm-sfa",path = "sfa",fallbackFactory = SfaWorkSignRuleInfoFeignImpl.class)
public interface SfaWorkSignRuleInfoFeign {

    /**
     * 列表
     */
    @PostMapping("/sfaworksignruleinfo/list")
    Result<PageResult<SfaWorkSignRuleInfoRespVo>> list(@RequestBody SfaWorkSignRuleInfoReqVo sfaWorkSignRuleInfoReqVo);

    /**
     * 查询
     */
    @PostMapping("/sfaworksignruleinfo/query")
    Result<SfaWorkSignRuleInfoRespVo> query(@RequestBody SfaWorkSignRuleInfoReqVo sfaWorkSignRuleInfoReqVo);

    /**
     * 新增
     */
    @PostMapping("/sfaworksignruleinfo/save")
    Result save(@RequestBody SfaWorkSignRuleInfoReqVo sfaWorkSignRuleInfoReqVo);

    /**
     * 更新
     */
    @PostMapping("/sfaworksignruleinfo/update")
    Result update(@RequestBody SfaWorkSignRuleInfoReqVo sfaWorkSignRuleInfoReqVo);

    /**
     * 删除
     */
    @PostMapping("/sfaworksignruleinfo/delete")
    Result delete(@RequestBody SfaWorkSignRuleInfoReqVo sfaWorkSignRuleInfoReqVo);

    /**
     * 启用
     */
    @PostMapping("/sfaworksignruleinfo/enable")
    Result enable(@RequestBody SfaWorkSignRuleInfoReqVo sfaWorkSignRuleInfoReqVo);

    /**
     * 禁用
     */
    @PostMapping("/sfaworksignruleinfo/disable")
    Result disable(@RequestBody SfaWorkSignRuleInfoReqVo sfaWorkSignRuleInfoReqVo);


    /**
     * 考勤明细报表列表
     */
    @PostMapping("/sfaworksignruleinfo/findWorkSignInfoList")
    Result<PageResult<SfaWorkSignInfoRespVo>> findWorkSignInfoList(@RequestBody SfaWorkSignInfoReqVo sfaWorkSignInfoReqVo);
}
