package com.biz.crm.sfa.worksign.impl;

import com.biz.crm.base.BaseAbstract;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.sfa.worksign.req.SfaWorkSignInfoReqVo;
import com.biz.crm.nebular.sfa.worksign.req.SfaWorkSignRuleInfoReqVo;
import com.biz.crm.nebular.sfa.worksign.resp.SfaWorkSignInfoRespVo;
import com.biz.crm.nebular.sfa.worksign.resp.SfaWorkSignRuleInfoRespVo;
import com.biz.crm.sfa.worksign.SfaWorkSignRuleInfoFeign;
import com.biz.crm.util.Result;
import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.util.ArrayList;

/**
 * 考勤规则明细表 feign接口熔断类
 *
 * @author liuhongming
 * @date 2020-10-14 15:05:08
 */
@Slf4j
@Component
public class SfaWorkSignRuleInfoFeignImpl extends BaseAbstract implements FallbackFactory<SfaWorkSignRuleInfoFeign> {

    @Override
    public SfaWorkSignRuleInfoFeign create(Throwable throwable) {
        log.error("进入熔断",throwable);
        return new SfaWorkSignRuleInfoFeign() {
             /**
              * 列表
              */
            @Override
            public Result<PageResult<SfaWorkSignRuleInfoRespVo>> list(SfaWorkSignRuleInfoReqVo sfaWorkSignRuleInfoReqVo) {
                doBack();
                PageResult<SfaWorkSignRuleInfoRespVo> build = PageResult.<SfaWorkSignRuleInfoRespVo>builder()
                        .data(new ArrayList<>())
                        .count(0L)
                        .build();
                return Result.ok(build);
            }

            /**
             * 查询
             */
            @Override
            public Result<SfaWorkSignRuleInfoRespVo> query(SfaWorkSignRuleInfoReqVo sfaWorkSignRuleInfoReqVo) {
                return doBack();
            }

            /**
             * 新增
             */
            @Override
            public Result save(SfaWorkSignRuleInfoReqVo sfaWorkSignRuleInfoReqVo) {
                return doBack();
            }

            /**
             * 更新
             */
            @Override
            public Result update(SfaWorkSignRuleInfoReqVo sfaWorkSignRuleInfoReqVo) {
                return doBack();
            }

            /**
             * 删除
             */
            @Override
            public Result delete(SfaWorkSignRuleInfoReqVo sfaWorkSignRuleInfoReqVo) {
                return doBack();
            }

            /**
             * 启用
             */
            @Override
            public Result enable(SfaWorkSignRuleInfoReqVo sfaWorkSignRuleInfoReqVo) {
                return doBack();
            }

            /**
             * 禁用
             */
            @Override
            public Result disable(SfaWorkSignRuleInfoReqVo sfaWorkSignRuleInfoReqVo) {
                return doBack();
            }

            /**
             * 考勤明细报表列表
             */
            @Override
            public Result<PageResult<SfaWorkSignInfoRespVo>> findWorkSignInfoList(SfaWorkSignInfoReqVo sfaWorkSignInfoReqVo){
                doBack();
                PageResult<SfaWorkSignInfoRespVo> build = PageResult.<SfaWorkSignInfoRespVo>builder()
                        .data(new ArrayList<>())
                        .count(0L)
                        .build();
                return Result.ok(build);
            }
        };
    }
}
