package com.biz.crm.sfa.worksignrule;

import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.sfa.worksignrule.req.SfaWorkSignPersonnelReqVo;
import com.biz.crm.nebular.sfa.worksignrule.resp.SfaWorkSignPersonnelRespVo;
import com.biz.crm.sfa.worksignrule.impl.SfaWorkSignPersonnelFeignImpl;
import com.biz.crm.util.Result;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * 考勤规则-打卡人员 feign接口
 *
 * @author liuhongming
 * @date 2020-09-16 15:06:20
 */


@FeignClient(url ="${feign.urlip:}",qualifier = "SfaWorkSignPersonnelFeign",name="crm-sfa",path = "sfa",fallbackFactory = SfaWorkSignPersonnelFeignImpl.class)
public interface SfaWorkSignPersonnelFeign {

    /**
     * 列表
     */
    @PostMapping("/sfaworksignpersonnel/list")
    Result<PageResult<SfaWorkSignPersonnelRespVo>> list(@RequestBody SfaWorkSignPersonnelReqVo sfaWorkSignPersonnelReqVo);

    /**
     * 查询
     */
    @PostMapping("/sfaworksignpersonnel/query")
    Result<SfaWorkSignPersonnelRespVo> query(@RequestBody SfaWorkSignPersonnelReqVo sfaWorkSignPersonnelReqVo);

    /**
     * 新增
     */
    @PostMapping("/sfaworksignpersonnel/save")
    Result save(@RequestBody SfaWorkSignPersonnelReqVo sfaWorkSignPersonnelReqVo);

    /**
     * 更新
     */
    @PostMapping("/sfaworksignpersonnel/update")
    Result update(@RequestBody SfaWorkSignPersonnelReqVo sfaWorkSignPersonnelReqVo);

    /**
     * 删除
     */
    @PostMapping("/sfaworksignpersonnel/delete")
    Result delete(@RequestBody SfaWorkSignPersonnelReqVo sfaWorkSignPersonnelReqVo);

    /**
     * 启用
     */
    @PostMapping("/sfaworksignpersonnel/enable")
    Result enable(@RequestBody SfaWorkSignPersonnelReqVo sfaWorkSignPersonnelReqVo);

    /**
     * 禁用
     */
    @PostMapping("/sfaworksignpersonnel/disable")
    Result disable(@RequestBody SfaWorkSignPersonnelReqVo sfaWorkSignPersonnelReqVo);
}
