package com.biz.crm.sfa.worksignrule;

import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.sfa.worksignrule.req.SfaWorkSignSpecialReqVo;
import com.biz.crm.nebular.sfa.worksignrule.resp.SfaWorkSignSpecialRespVo;
import com.biz.crm.sfa.worksignrule.impl.SfaWorkSignSpecialFeignImpl;
import com.biz.crm.util.Result;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * 特殊日期 feign接口
 *
 * @author liuhongming
 * @date 2020-09-16 15:06:20
 */


@FeignClient(url ="${feign.urlip:}",qualifier = "SfaWorkSignSpecialFeign",name="crm-sfa",path = "sfa",fallbackFactory = SfaWorkSignSpecialFeignImpl.class)
public interface SfaWorkSignSpecialFeign {

    /**
     * 列表
     */
    @PostMapping("/sfaworksignspecial/list")
    Result<PageResult<SfaWorkSignSpecialRespVo>> list(@RequestBody SfaWorkSignSpecialReqVo sfaWorkSignSpecialReqVo);

    /**
     * 查询
     */
    @PostMapping("/sfaworksignspecial/query")
    Result<SfaWorkSignSpecialRespVo> query(@RequestBody SfaWorkSignSpecialReqVo sfaWorkSignSpecialReqVo);

    /**
     * 新增
     */
    @PostMapping("/sfaworksignspecial/save")
    Result save(@RequestBody SfaWorkSignSpecialReqVo sfaWorkSignSpecialReqVo);

    /**
     * 更新
     */
    @PostMapping("/sfaworksignspecial/update")
    Result update(@RequestBody SfaWorkSignSpecialReqVo sfaWorkSignSpecialReqVo);

    /**
     * 删除
     */
    @PostMapping("/sfaworksignspecial/delete")
    Result delete(@RequestBody SfaWorkSignSpecialReqVo sfaWorkSignSpecialReqVo);

    /**
     * 启用
     */
    @PostMapping("/sfaworksignspecial/enable")
    Result enable(@RequestBody SfaWorkSignSpecialReqVo sfaWorkSignSpecialReqVo);

    /**
     * 禁用
     */
    @PostMapping("/sfaworksignspecial/disable")
    Result disable(@RequestBody SfaWorkSignSpecialReqVo sfaWorkSignSpecialReqVo);
}
